PWE.integrationComponent.registerFormAction("get-data-from-datasource-action", {
  apiVersion: 2,
  buildForm: function(form, options) {
    this.destination = options.destination;
    handle(form, this.destination);
  }
});

function handle(form, destination) {
  DataSource.buildDataSourceSelectionCombobox(
    form,
    DataSource.Operations.READ,
    "datasource",
    "datasources"
  );

  DataSource.buildParametersForNonDatachooser(form, {
    datasourceParamId: "datasource",
    datasourcesParamId: "datasources",
    datasourceInputParametersId: "datasourceInputParametersId",
    datasourceInputParametersValue: "datasourceInputParametersValue",
    datasourceOutputParametersId: "datasourceOutputParametersId",
    datasourceOutputParametersValue: "datasourceOutputParametersValue"
  });

  form.addCombobox({
    id: "manyValuesHandler",
    forceSelection: true,
    values:
      destination !== "VARIABLESET"
        ? [
            {
              id: "block",
              display: CUFCommon.t("datasource.handleManyVals.block.name"),
              description: CUFCommon.t("datasource.handleManyVals.block.desc")
            },
            {
              id: "first",
              display: CUFCommon.t("datasource.handleManyVals.first.name"),
              description: CUFCommon.t("datasource.handleManyVals.first.desc")
            },
            {
              id: "unique",
              display: CUFCommon.t("datasource.handleManyVals.unique.name"),
              description: CUFCommon.t("datasource.handleManyVals.unique.desc")
            }
          ]
        : [
            {
              id: "block",
              display: CUFCommon.t("datasource.handleManyVals.block.name"),
              description: CUFCommon.t("datasource.handleManyVals.block.desc")
            },
            {
              id: "first",
              display: CUFCommon.t("datasource.handleManyVals.first.name"),
              description: CUFCommon.t("datasource.handleManyVals.first.desc")
            }
          ]
  });
  if (destination !== "VARIABLESET") {
    form.addField("overwriteData");
  }
}
