/**
 * Implementation of AttachDocumentsFromDisk
 */
PW.FormActions.create('attach-document', {
	
	buttonInit : function(button) {
		this.button = button;
	},
	
	defaultActions : {
        button: function(){
			this.attachDocument();
        }
    },
    
    enable : function() {
    	if (!this.button) {
			this.attachDocument();
		}
    },
    
    attachDocument : function(){
        var cfg = {
        	showIndexes : this.get("showIndexes"),
        	checkRights : this.get("checkRights"),
        	autoSelectFirst : this.get("autoSelectFirst"),
        	documentClassIdList : this.get("documentClassIdList") ? this.get("documentClassIdList") : undefined, 
        	documentClassNameList : this.get("documentClassNameList"),
        	callback : new Function("doc", this.get("callback")),
        	savingAsNewVersion : this.getSaveAsNewVersionBooleanValues(this.get("savingAsNewVersion")),
			acceptedExtensions : this.get("allowedExtensions")
        };
        CUF.DocumentService.showAddDocumentsFromDiscForm(cfg);
    },
    
    getSaveAsNewVersionBooleanValues : function(name){
    	var savingAsNewVersionField = new Object();
    	switch (name) {			
    	  case "TrueAndEditable":
			savingAsNewVersionField.checked = true;
			savingAsNewVersionField.readOnly = false;
			break;
		  case "TrueAndUneditable":
			savingAsNewVersionField.checked = true;
			savingAsNewVersionField.readOnly = true;
			break;
		  case "FalseAndEditable":
			savingAsNewVersionField.checked = false;
			savingAsNewVersionField.readOnly = false;
			break;
		  case "FalseAndUneditable":
			savingAsNewVersionField.checked = false;
			savingAsNewVersionField.readOnly = true;
    	}
    	return savingAsNewVersionField;   	
    }
});

