/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.process.functions;

import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionContext;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;

@Functions
@FunctionsScript(value="/functions/process-functions.js")
public class ProcessFunctions {
    @Autowired
    private ProcessService processService;

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public String getProcessState(String processId) {
        Process process = this.processService.getProcess(processId, new String[0]);
        return process.getState().getStateText();
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public Boolean isProcessState(String processId, String[] state) {
        Process process = this.processService.getProcess(processId, new String[0]);
        return Arrays.asList(state).contains(process.getState().getStateText());
    }

    @Function
    public String currentProcessName() {
        FunctionContext functionContext = FunctionContext.current();
        return this.processService.getProcess(functionContext.getProcessId(), new String[0]).getName();
    }
}

