PWE.integrationComponent.registerFormAction('tablestore-filter', {
    apiVersion: 2,
    buildForm: function(form, options) {
	    form.addField('srcTableStore');
		form.addCombobox({
			id: 'logicalOperator',
			values: [
				{ id: 'and', display: 'AND' },
				{ id: 'or', display: 'OR' }
			], notEmpty: false, optional: false
		});
		if (!form.getValue('logicalOperator')) {			
			form.setValue('logicalOperator', 'and');
		}
        var table = form.addTable('fieldsTable');
        table.addField('fieldIds');
        table.addCombobox({
            id: 'operators',
            values: [
                { id: '=', display: '=' },
                { id: '!=', display: '!=' },
                { id: '<', display: '<' },
                { id: '<=', display: '<=' },
                { id: '>', display: '>' },
                { id: '>=', display: '>=' },
				{ id: 'regex', display: 'regex' }
            ], notEmpty: false, optional: false
		});
        table.addField('values');
		form.addField('targetTableStore');
    },
	validateForm: function(api) {
		if (api.getVariableType('targetTableStore') !== 'string') {
			api.markError('targetTableStore');
			api.showErrorMessage(CUFCommon.t('form-valid-string'));
			return false;
		}
		return true;
	}
});