PWE.integrationComponent.registerFormAction('table-remove-all-records', {
    apiVersion: 2,
    buildForm: function(form, options) {
        form.addField('tableStore');
		form.addField({
			id: 'wipeData',
			listeners: {
			    change: function(value) {
                    if (value && options.destination === 'BUTTON') {
	                	form.addField('tableId');
            			form.setNotEmpty('tableId', true);
                    } else {
	                    form.removeField('tableId');
                        form.setNotEmpty('tableId', false);
                    }
			    }
		    }
		});
		if (form.getValue('wipeData')) {
			form.addField('tableId');
			form.setNotEmpty('tableId', true);
		}
    },
	validateForm: validate
});

PWE.integrationComponent.registerApplication('table-remove-all-records-app', {
    apiVersion: 2,
    buildForm: buildForm,
	validateForm: validate
});

PWE.integrationComponent.registerVariablesSetter('table-remove-all-records-app', {
    apiVersion: 2,
    buildForm: buildForm,
	validateForm: validate
});

function buildForm(form) {
	form.addField('tableStore');
	form.addField({
		id: 'wipeData',
		listeners: {
		    change: function(value) {
                if (value) {
	               	form.addField('tableId');
                    form.addField('activityDefId');
					form.setNotEmpty('tableId', true);
					form.setNotEmpty('activityDefId', true);
                } else {
	                form.removeField('tableId');
                    form.removeField('activityDefId');
					form.setNotEmpty('tableId', false);
					form.setNotEmpty('activityDefId', false);
                }
		    }
		}
	});
	if (form.getValue('wipeData')) {
		form.addField('tableId');
        form.addField('activityDefId');
		form.setNotEmpty('tableId', true);
		form.setNotEmpty('activityDefId', true);
	}
}

function validate(api) {
	if (!api.hasVariableValue('tableStore')) {
		api.markError('tableStore');
		api.showErrorMessage(CUFCommon.t('form-valid-value-must-be-a-variable'));
		return false;
	}
	return true;
}
