
/**
 * Set info to target variable about whether a given user has a given role assigned to them.
 */
PW.FormActions.create('check-user-role-action', {

	variableInit : function(variable) {
		this.targetVariable = variable;
	},
	
	buttonInit : function(button) {
		this.button = button;
	},
	
	defaultActions: {
        button: function(button){
             this.setInfo();
         }
     },
	
	addToLock : function(variable) {
		this.lock = new Suncode.form.plugin.locking.Lock();
		this.lock.pushVariable(variable);
	},
	
	enable : function() {
		if (!this.button) {
			this.setInfo();
		}
	},

	setInfo : function() {
		this.addToLock(this.targetVariable)
		var lock = this.lock,
			userName = this.get("userName"),
			roleId = this.get("roleId"),
			searchInPackage = this.get("searchInPackage"),
			processId = ServiceFactory.getActivityInfoService().getProcessId(),
			targetVariable = this.get("targetVariable");
		lock.lock();
		
		var request = jQuery.ajax({
			type : "GET",
			data : {
				userName : userName,
				roleId : roleId,
				searchInPackage: searchInPackage,
				processId : processId
			},
			url : "plugin/com.suncode-cuf-components/user/has-role/",
			error :  function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			}, 
			async : true
		})
		.done(function (data){
			if (devMode){
	    		Logger.debug("Action user-role-check will now set variables...");
	    	}
			targetVariable.setValue(data);
		})
		.fail(function(){
			Logger.error("Request failed.");
		})
		.always(function(){
			lock.unlock();
		});
	}
});