PW.FormActions.create('table-insert-records', {
    defaultActions: {
        button: function() {
            this.insertRecords();
        },
        dtButton: function() {
            this.insertRecords();
        }
    },

    insertRecords: function() {
		try {
			var tableStoreToInsert = this.get('tableStoreToInsert');
    		var tableStoreToInsertObj = JSON.parse(tableStoreToInsert);
			var mappingType = this.get('mappingType');
			switch(mappingType) {
				case 'manual': {
					this.handleManualMappingType(tableStoreToInsert, tableStoreToInsertObj);
					break;
				}
				case 'table': {
					this.handleTableMappingType(tableStoreToInsert, tableStoreToInsertObj);
					break;
				}
			} 	
		} catch(err) {
			console.error(err);
			alert(CUFCommon.t('action.invoking-action-error-occured'));
		}
    },

	handleManualMappingType: function(tableStoreToInsert, tableStoreToInsertObj) {
		var mappingIds = this.get('mappingIds');
    	var mappingValues = this.get('mappingValues');
    	if (mappingIds.length !== mappingValues.length) {
       		throw new Error('Mapping lists length mismatch!');
    	}
    	var valuesToSet = [];
		for (var i = 0; i < mappingIds.length; i++) {
       		var valuesArray = TableStore.getFieldValues(tableStoreToInsert, mappingIds[i]);
       		if (tableStoreToInsertObj.variableType[mappingIds[i]] !== mappingValues[i].getType().name.replace('[]', '')) {
				throw new Error('Cannot map TableStore\'s key ' + mappingIds[i] + ' ('
				+ tableStoreToInsertObj.variableType[mappingIds[i]] + '[]) onto ' + mappingValues[i].getId()
				+ ' (' + mappingValues[i].getType().name + ') variable because of type mismatch!');
			}
			if (this.get('overwriteData')) {
				if (mappingValues.length > 0) {
					mappingValues[0].getVariableSet().clear();
				}
				valuesToSet.push(valuesArray);
			} else {
				var existingValues = mappingValues[i].getValue();
				if (existingValues.length > 0 && existingValues[0] instanceof Date) {
					existingValues = existingValues.map(function (value) {
						if (value instanceof Date) {
							value.setHours(12);
							return value.toISOString().substring(0,10);
						}
						return value;
					});
				}
				valuesToSet.push(existingValues.concat(valuesArray));
			}	
    	}
		for (var i = 0; i < mappingIds.length; i++) {
			mappingValues[i].setValue(valuesToSet[i]);
		}
	},
	
	handleTableMappingType: function(tableStoreToInsert, tableStoreToInsertObj) {
		var tableId = this.get('tableId');
		var variableSet = VariableSetService.getVariableSet(tableId);
		if (!variableSet) throw new Error('No VariableSet of id "' + tableId  + '" found!');
		var variables = variableSet.getVariables();
		var isTableStoreFitsInTableVariables = Object.keys(tableStoreToInsertObj.variableType).all(function(key) {
			return variables.any(function(variable) {
				return key === variable.getId();
			});
		});
		if (isTableStoreFitsInTableVariables) {
			if (this.get('overwriteData')) {
				variableSet.clear();
			}
			var valuesToSet = {};
			Object.keys(tableStoreToInsertObj.variableType).forEach(function(id) {
				var variable = getVariableById(variableSet.getVariables(), id);
				var existingValues = variable.getValue();
				if (existingValues.length > 0 && existingValues[0] instanceof Date) {
					existingValues = existingValues.map(function (value) {
						if (value instanceof Date) {
							value.setHours(12);
							return value.toISOString().substring(0,10);
						}
						return value;
					});
				}
				valuesToSet[id] = existingValues.concat(TableStore.getFieldValues(tableStoreToInsert, id));
			});
			Object.keys(valuesToSet).forEach(function(id) {
				var variable = getVariableById(variableSet.getVariables(), id);
				variable.setValue(valuesToSet[id]);
			});
		} else {
			throw new Error('Cannot map TableStore with keys "' + JSON.stringify(tableStoreToInsertObj).variableType
			+ '" onto VariableSet "' + tableId + '"!');
		}
	}
});

function getVariableById(variables, id) {
	return variables.find(function(vrbl) {
		return vrbl.getId() === id;
	});
}
