/**
 * Delete selected implementation
 */
PW.FormActions.create('paint-rows', {
    variableSetInit: function (table) {
        var conditionFn = this.get("condition");
        if (!conditionFn || conditionFn.getReturnType() !== PW.BooleanType) {
            Logger.error('Action paints-rows needs boolean function in condition parameter.');
            return;
        }
        this.columsID = [];
        var columns = this.get("columns");
        for (var index = 0; index < columns.length; index++) {
            this.columsID.push(columns[index].getId());
        }
        this.setContextVariable("currentRow", 0);
        this.table = table;
        this.conditionalRender();
    },

    enable: function () {
        this.isEnable = true;
        this.table.refresh();
        this.get("condition").on("change", function () {
            this.table.refresh();
        }, this);
    },


    disable: function () {
        this.isEnable = false;
        this.table.refresh();
        this.get("condition").off("change", function () {
            this.table.refresh();
        }, this);
    },

    paint: function (me, metaData, column) {
        var color = this.resolveColor(me.get("color"));
        var cssColor = color ? 'color: ' + color : "";

        var colorBG = this.resolveColor(me.get("colorBG"));
        var cssColorBG = colorBG ? 'background-color: ' + colorBG : "";

        if (metaData.row < me.columnLength(column)) {
            me.setContextVariable("currentRow", metaData.row);
            me.setContextVariable("columnId", column);
            if (me.get("condition").call()) {
                metaData.style = cssColor + ";" + cssColorBG + ";";
            }
        }
    },

    resolveColor: function (color) {
        //kompatybilność wstecz
        if (color && (color.indexOf('#') < 0)) {
            color = "#" + color;
        }
        return color;
    },

    conditionalRender: function () {
        var me = this;
        VariableSetService.addRenderer(me.table.grid, function (value, data, column, metaData) {
            if (me.isEnable) {
                me.paint(me, metaData, column);
            }
        }, me.columsID);
    },
    columnLength: function (column) {
        var tableVariables = this.table.getVariables();
        for (var i = 0; i < tableVariables.length; i++) {
            if (tableVariables[i].id == column) {
                return tableVariables[i].getValue().length;
            }
        }
        return -1;
    }

});