PW.FormActions.create("get-data-from-datasource-action", {
  init: function () {
    this.datasource = this.get("datasource");
    this.datasources = this.get("datasources");
    this.datasourceInputParametersId = this.get("datasourceInputParametersId");
    this.datasourceInputParametersValue = this.getRaw("datasourceInputParametersValue").value;
    this.datasourceOutputParametersId = this.get("datasourceOutputParametersId");
    this.datasourceOutputParametersValue = this.get("datasourceOutputParametersValue");
    this.manyValuesHandler = this.getRaw("manyValuesHandler");
    this.overwriteData = this.getRaw("overwriteData");
    if (this.target.type === "VARIABLESET") {
      this.targetTable = ServiceFactory.getVariableSetService().getVariableSet(this.target.id);
      this.targetTableItemsArray = this.targetTable.grid.store.data.items;
    }
  },

  defaultActions: {
    button: function (_button) {
      this.requestData();
    },
    dtButton: function (_variable, _newValue, _oldValue) {
      this.requestData();
    },
  },

  enable: function () {
    if (this.target.type === "FORM") {
      this.requestData();
    } else if (this.target.type === "VARIABLESET") {
      this.requestDataInVariableSet();
    }
  },

  requestData: function () {
    if (this.datasourceInputParametersId.length !== this.datasourceInputParametersValue.length) {
      throw new Error("Input parameters lists has different sizes!");
    }

    var inputParametersValue = [];
    this.datasourceInputParametersValue.forEach(function (parameterObj) {
      if (typeof parameterObj.get() === "string") {
        inputParametersValue.push(parameterObj.get());
      } else {
        if (typeof parameterObj.get().getValue() === "string") {
          inputParametersValue.push(parameterObj.get().getValue());
        } else {
          inputParametersValue.push(parameterObj.get().getValue().join(";"));
        }
      }
    });

    var query = this.prepareQuery(this.datasource, {
      ids: this.datasourceInputParametersId,
      values: inputParametersValue,
    });

    var mapVariables = this.mapVariables.bind(this);
    var outputParameters = {
      ids: this.datasourceOutputParametersId,
      values: this.datasourceOutputParametersValue,
    };

    var overwriteData = this.overwriteData.get();
    var manyValuesHandler = this.manyValuesHandler.get();

    jQuery.get(encodeURI(query), function (data) {
      mapVariables(data, outputParameters, overwriteData, manyValuesHandler);
    });
  },

  prepareQuery: function (datasource, inputParameters) {
    return (
      "plugin/com.suncode-cuf-components/datasource/get-data?datasource=" +
      datasource +
      "&datasourceInputParametersId=" +
      JSON.stringify(inputParameters.ids) +
      "&datasourceInputParametersValue=" +
      JSON.stringify(
        inputParameters.values.map(function (param) {
          if (Array.isArray(param)) {
            return param.join(";");
          }
          return param;
        })
      )
    );
  },

  mapVariables: function (data, outputParameters, overwriteData, manyValuesHandler) {
    if (outputParameters.ids.length !== outputParameters.values.length) {
      throw new Error("Parameter lists lengths are not equal!");
    }

    var parametersList = this.getParametersList(data, outputParameters.ids);
    var currentPositions = this.storeCurrentPositions(outputParameters.values);

    for (i = 0; i < outputParameters.values.length; i++) {
      if (outputParameters.values[i].isStandaloneVariable) {
        if (parametersList[i].length === 1) {
          this.handleFirst(outputParameters.values[i], parametersList[i]);
        } else {
          switch (manyValuesHandler) {
            case "first":
              this.handleFirst(outputParameters.values[i], parametersList[i]);
              break;
            case "unique":
              this.handleUnique(outputParameters.values[i], parametersList[i]);
              break;
            case "block":
              throw new Error(
                "Datasource is returning more than one set of values. Cannot map it to variable that is not an array type!"
              );
          }
        }
      } else {
        if (overwriteData) {
          if (i === 0) {
            outputParameters.values[i].variableSet.clear();
          }
          outputParameters.values[i].setValue(parametersList[i]);
        } else {
          outputParameters.values[i].setValue(currentPositions[i].concat(parametersList[i]));
        }
      }
    }
  },

  getParametersList: function (data, ids) {
    var parametersList = this.prepareList(ids);
    for (var i = 0; i < ids.length; i++) {
      for (var j = 0; j < data.length; j++) {
        parametersList[i].push(data[j][ids[i]].toString());
      }
    }
    return parametersList;
  },

  prepareList: function (ids) {
    var parametersList = [];
    for (var i = 0; i < ids.length; i++) {
      parametersList.push([]);
    }
    return parametersList;
  },

  storeCurrentPositions: function (values) {
    var currentPositions = [];
    for (var i = 0; i < values.length; i++) {
      currentPositions.push(values[i].getValue(i));
    }
    return currentPositions;
  },

  handleFirst: function (variable, value) {
    variable.setValue(value[0]);
  },

  handleUnique: function (variable, value) {
    var unique = value.filter(function (value, index, self) {
      return self.indexOf(value) === index;
    });
    variable.setValue(unique.join(";"));
  },

  requestDataInVariableSet: function () {
    this.areAllInputParametersNotArrays = this.areAllInputParametersNotOfVariableSetType();
    this.checkIfInputParametersHasEqualSize();
    this.targetTableItemsArray.forEach(function (_item, index) {
      this.requestAndSetDataOnPosition(index);
    }, this);

    this.datasourceInputParametersValue.forEach(function (inputParameter) {
      var parameterValue = inputParameter.get();
      if (parameterValue.variableSet === undefined) {
        parameterValue.on("change", this.onVariableChangeHandler.bind(this));
      }
    }, this);

    this.targetTable.on("change", this.onVariableSetChangeHandler.bind(this));
  },

  areAllInputParametersNotOfVariableSetType: function () {
    return this.datasourceInputParametersValue.every(function (inputParameter) {
      return !Array.isArray(inputParameter.get().getValue());
    });
  },

  checkIfInputParametersHasEqualSize: function () {
    this.datasourceInputParametersValue.forEach(function (inputParameter) {
      var inputParameterValue = inputParameter.get().getValue();
      if (Array.isArray(inputParameterValue)) {
        if (inputParameterValue.length !== this.targetTableItemsArray.length) {
          throw new Error("Datasource's input array parameters have different sizes!");
        }
      }
    }, this);
  },

  onVariableChangeHandler: function (_variable, _newValue, _oldValue) {
    this.storedData = undefined;
    this.targetTable.suspendEvents();
    this.targetTableItemsArray.forEach(function (_item, index) {
      this.requestAndSetDataOnPosition(index);
    }, this);
    this.targetTable.resumeEvents();
  },

  onVariableSetChangeHandler: function (_variableSet, added, updated, _removed) {
    this.targetTable.suspendEvents();
    if (added.length > 0) this.requestLoop(added);
    if (updated.length > 0) this.requestLoop(updated);
    this.targetTable.resumeEvents();
  },

  requestLoop: function (array) {
    array.forEach(function (item) {
      this.requestAndSetDataOnPosition(item.index);
    }, this);
  },

  requestAndSetDataOnPosition: function (index) {
    var changedValues = [];
    this.datasourceInputParametersValue.forEach(function (inputParamValue) {
      var parameterValue = inputParamValue.get().getValue();
      if (Array.isArray(parameterValue)) {
        changedValues.push(parameterValue[index]);
      } else {
        changedValues.push(parameterValue);
      }
    });
    if (this.storedData === undefined) {
      var query = this.prepareQuery(this.datasource, {
        ids: this.datasourceInputParametersId,
        values: changedValues,
      });
      jQuery.ajax({
        url: encodeURI(query),
        type: "get",
        async: false,
        success: function (data) {
          this.setDataValues(data, index, changedValues);
        }.bind(this),
      });
    } else {
      this.setDataValues(this.storedData, index, changedValues);
    }
  },

  setDataValues: function (data, index, changedValues) {
    if (this.areAllInputParametersNotArrays) {
      this.storedData = data;
    }
    if (data.length > 0) {
      if (data.length === 1 || this.manyValuesHandler.get() === "first") {
        this.datasourceOutputParametersId.forEach(
          function (inputParamId, i) {
            var mappedDataFromRequest = data[0][inputParamId];
            if (mappedDataFromRequest !== undefined) {
              this.datasourceOutputParametersValue[i].setItemValue(mappedDataFromRequest, index);
            } else {
              this.datasourceOutputParametersValue[i].setItemValue(null, index);
            }
          }.bind(this)
        );
      } else {
        throw new Error("Datasource returned more than one result!");
      }
    } else {
      this.datasourceOutputParametersValue.forEach(function (outputParamValue) {
        outputParamValue.setItemValue(null, index);
      });
      console.warn(
        "Cannot retrive data with params:",
        this.datasourceInputParametersId,
        changedValues
      );
    }
  },
});
