PW.FormActions.create('block-table-buttons', {

    variableSetInit: function (table) {
        this.table = table;
    },

    enable: function () {
        if (this.checkIfDisableConditionParameterSpecified()) {
            this.table.on("select", this.updateButtonsOnSelect, this);
            this.table.on("change", this.updateButtonsOnChange, this);
        } else {
            this.toggleButtonsState(true);
        }
    },

    disable: function () {
        if (this.checkIfDisableConditionParameterSpecified()) {
            this.table.off("select", this.updateButtonsOnSelect, this);
            this.table.off("change", this.updateButtonsOnChange, this);
        } else {
            this.toggleButtonsState(false);
        }
    },

    updateButtonsOnSelect: function (variableSet, selected) {
        this.updateButtons(selected[0]);
    },

    updateButtonsOnChange: function (variableSet, added, updated, removed) {
        if (updated.length && updated[0].index === this.getSelectedRowIndex()) {
            this.updateButtons(updated[0]);
        }
    },

    updateButtons: function (row) {
        this.setContextVariable("currentRow", row.index);
        this.toggleButtonsState(this.get("disableCondition"));
    },

    toggleButtonsState: function (disable) {
        let buttonsIds = this.get("buttonsIds");
        PW.each(buttonsIds, function (buttonId) {
            if (disable) {
                this.table.disableButton(buttonId);
            } else {
                this.table.enableButton(buttonId);
            }
        }, this);
    },

    getSelectedRowIndex: function () {
        return this.table.grid.getStore().indexOf(this.table.grid.getSelectionModel().getSelection()[0]);
    },

    checkIfDisableConditionParameterSpecified: function () {
        return this.getRaw("disableCondition")?.value?.value != null;
    }
});