PW.FormActions.create("add-row", {
    variableSetInit: function (table) {
        this.table = VariableSetService.get(table.getId());
    },

    dtButtonInit: function (button) {
        const tableId = button.getVariableSet().getId();
        this.table = VariableSetService.get(tableId);
    },

    buttonInit: function () {
        this.table = VariableSetService.get(this.get("tableId"));
        if (this.table === undefined) {
            Logger.error(CUFCommon.t("action.add-row.no-table-id"));
            MessageService.showFailure(CUFCommon.t("action.add-row.no-table-id"));
        }
    },

    defaultActions: {
        button: function () {
            this.addRow();
        },
        dtButton: function () {
            this.addRow();
        }
    },

    enable: function () {
        if (this.target.type === "VARIABLESET") {
            this.addRow();
        }
    },

    addRow: function () {
        const row = {};
        const setRowPosition = this.get("setRowPosition");
        let index = this.get("rowPosition");

        if (index < 0) {
            index = 0;
        }

        PW.each(this.get("columns"), function (column, index) {
            row[column.getId()] = this.get("values")[index];
        }, this);
        if (Ext4.Object.isEmpty(row)) {
            if (setRowPosition) {
                VariableSetService.insertRow(this.table, index);
            } else {
                VariableSetService.addRow(this.table);
            }
        } else {
            if (setRowPosition) {
                VariableSetService.insertRow(this.table, index, false, row);
            } else {
                VariableSetService.addRow(this.table, false, row);
            }
        }
    }
});