PW.Functions.register("Regex.match", "string[]", ["string", "string"], function (regex, text) {
    return processRegex(regex, text, false);
});

PW.Functions.register("Regex.group", "string[]", ["string", "string"], function (regex, text) {
    return processRegex(regex, text, true);
});

function processRegex(regex, text, includeGroups) {
    if (!regex) {
        return [];
    }

    const pattern = new RegExp(regex, 'g');
    const results = [];
    let match;

    while ((match = pattern.exec(text)) !== null) {
        if (match.index === pattern.lastIndex) {
            pattern.lastIndex++;
        }

        if (includeGroups) {
            for (let i = 1; i < match.length; i++) {
                results.push(match[i]);
            }
        } else {
            results.push(match[0]);
        }
    }

    return results;
}
