/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.LogUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Validator
public class ValidateUsingFunction {
    private static final Logger log = LoggerFactory.getLogger(ValidateUsingFunction.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("function-based-validator")).name("validator.function.name")).description("validator.function.desc")).category(new Category[]{Categories.GENERAL})).documentationLink("confluence/x/MoTK")).icon((Icon)SilkIconPack.SCRIPT)).parameter().id("function").name("validator.function.function_param.name").description("validator.function.function_param.desc").type((Type)Types.FUNCTION).create()).parameter().id("messageType").name("validator.function.messageType.name").description("validator.function.messageType.desc").defaultValue((Object)"global").type((Type)Types.STRING).create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("alert").name("validator.function.alert_global.name").description("validator.alert_param.desc_default").type((Type)Types.STRING).optional().create()).parameter().id("tableOn").name("validator.function.tableOn.name").description("validator.function.tableOn.desc").type((Type)Types.STRING).defaultValue((Object)"noTable").optional().create()).parameter().id("everyRowAvailable").name("validator.function.everyRowAvailable.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("anyRowAvailable").name("validator.function.anyRowAvailable.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("tableLength").name("validator.function.tableLength.name").description("validator.function.tableLength.desc").type((Type)Types.INTEGER).optional().create()).parameter().id("variable").name("validator.function.variable.name").description("validator.function.variable.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("variableMessage").name("validator.function.variableMessange.name").description("validator.function.variableMessange.desc").type((Type)Types.STRING_ARRAY).optional().create()).contextVariable().id("everyRow").name("validator.function.everyRow.name").type((Type)Types.INTEGER).hidden().create().contextVariable().id("anyRow").name("validator.function.anyRow.name").type((Type)Types.INTEGER).hidden().create().contextVariable().id("rowId").name("validator.function.rowId.name").type((Type)Types.INTEGER).create();
    }

    public void validate(@Param FunctionCall function, @Param Integer tableLength, @Param String messageType, @Param Boolean confirmation, @Param String alert, @Param Variable[] variable, @Param String[] variableMessage, @Param Boolean everyRowAvailable, @Param Boolean anyRowAvailable, ContextVariables contextVariables, ValidationErrors errors, ValidationContext context, Translator translator) {
        try {
            Type type = function.getReturnType();
            Assert.isTrue((type == Types.BOOLEAN ? 1 : 0) != 0, (String)"Wrong type of returned function value.");
            this.valid(function, confirmation, alert, tableLength, everyRowAvailable, anyRowAvailable, messageType, variable, variableMessage, contextVariables, errors, translator, (WorkflowContext)context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void valid(FunctionCall function, Boolean confirmation, String alert, Integer tableLength, Boolean everyRowAvailable, Boolean anyRowAvailable, String msgType, Variable[] var, String[] msg, ContextVariables contextVariables, ValidationErrors errors, Translator translator, WorkflowContext context) {
        ArrayList<Integer> rowNotValid = new ArrayList<Integer>();
        try {
            LogUtils logUtils = new LogUtils(context);
            if (everyRowAvailable.booleanValue() && !this.everyRowValidate(tableLength, contextVariables, function, rowNotValid, logUtils)) {
                this.chooseMsg(msgType, confirmation, alert, translator, errors, var, msg, rowNotValid);
            } else if (anyRowAvailable.booleanValue() && !this.anyRowValidate(tableLength, contextVariables, function, rowNotValid, logUtils)) {
                this.chooseMsg(msgType, confirmation, alert, translator, errors, var, msg, rowNotValid);
            } else if (!(everyRowAvailable.booleanValue() || anyRowAvailable.booleanValue() || ((Boolean)function.call()).booleanValue())) {
                this.chooseMsg(msgType, confirmation, alert, translator, errors, var, msg, rowNotValid);
            }
        }
        catch (Exception e) {
            if (this.checkArrayIndexOutOfBoundsException(e)) {
                this.globalMsg(confirmation, errors, translator.getMessage("validator.array_length_error") + " : " + tableLength, translator);
            }
            throw new RuntimeException(e);
        }
    }

    private boolean checkArrayIndexOutOfBoundsException(Throwable e) {
        while (e != null) {
            if (e instanceof ArrayIndexOutOfBoundsException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private boolean anyRowValidate(Integer tableLength, ContextVariables contextVariables, FunctionCall function, List<Integer> rowNotValid, LogUtils logUtils) {
        if (tableLength == null) {
            throw new IllegalArgumentException("Nie podano d\u0142ugo\u015bci tabeli");
        }
        if (tableLength <= 0) {
            return true;
        }
        Boolean flag = false;
        for (int i = 0; i < tableLength; ++i) {
            contextVariables.set("rowId", (Object)i);
            contextVariables.set("anyRow", (Object)i);
            logUtils.disableLoggingIfLimitReached(i);
            logUtils.debug("anyRowValidate function call");
            if (((Boolean)function.call()).booleanValue()) {
                flag = true;
                continue;
            }
            rowNotValid.add(i);
        }
        return flag;
    }

    private boolean everyRowValidate(Integer tableLength, ContextVariables contextVariables, FunctionCall function, List<Integer> rowNotValid, LogUtils logUtils) {
        if (tableLength == null) {
            throw new IllegalArgumentException("Nie podano d\u0142ugo\u015bci tabeli");
        }
        if (tableLength <= 0) {
            return true;
        }
        Boolean flag = true;
        for (int i = 0; i < tableLength; ++i) {
            contextVariables.set("rowId", (Object)i);
            contextVariables.set("everyRow", (Object)i);
            logUtils.disableLoggingIfLimitReached(i);
            logUtils.debug("everyRowValidate function call");
            if (((Boolean)function.call()).booleanValue()) continue;
            flag = false;
            rowNotValid.add(i);
        }
        return flag;
    }

    private void globalMsg(Boolean confirmation, ValidationErrors errors, String alert, Translator translator) {
        if (confirmation.booleanValue()) {
            errors.addConfirmation(alert, translator.getMessage("validator.title_default"));
        } else {
            errors.add(alert);
        }
    }

    private void localMsg(ValidationErrors errors, Variable[] var, String[] msg, Translator translator, List<Integer> rowNotValid) {
        Assert.isTrue((var.length == msg.length ? 1 : 0) != 0, (String)"the table of variables and messages are not the same length");
        for (int i = 0; i < var.length; ++i) {
            if (StringUtils.isBlank((CharSequence)msg[i])) continue;
            if (var[i].isArray()) {
                if (rowNotValid.isEmpty()) {
                    errors.add("[" + var[i].getName() + "] " + msg[i]);
                    continue;
                }
                for (Integer rowIndex : rowNotValid) {
                    errors.add(msg[i], var[i].getId(), rowIndex.intValue());
                }
                continue;
            }
            errors.add(msg[i], var[i].getId());
        }
    }

    private void chooseMsg(String msgType, Boolean confirmation, String alert, Translator translator, ValidationErrors errors, Variable[] var, String[] msg, List<Integer> rowNotValid) {
        switch (msgType.toLowerCase()) {
            case "global": {
                this.globalMsg(confirmation, errors, alert, translator);
                break;
            }
            case "local": {
                this.localMsg(errors, var, msg, translator, rowNotValid);
                break;
            }
            case "localandglobal": {
                this.globalMsg(confirmation, errors, alert, translator);
                this.localMsg(errors, var, msg, translator, rowNotValid);
                break;
            }
            default: {
                this.globalMsg(confirmation, errors, alert, translator);
            }
        }
    }
}

