/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.functions;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionContext;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Functions
public class DocumentFunctions {
    @Autowired
    DocumentClassService documentClassService;
    @Autowired
    DocumentFinder documentFinder;

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public Long numberOfDocumentsFromCurrentProcess() {
        FunctionContext context = FunctionContext.current();
        List docList = this.documentFinder.getDocumentsFromProcess(context.getProcessId(), new String[0]);
        return new Long(docList.size());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public Long numberOfDocumentsFromCurrentProcess(String[] classNames) {
        return this.documentsFromCurrentProcess(classNames).length;
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public Long[] documentsFromCurrentProcess(String[] classNames) {
        FunctionContext context = FunctionContext.current();
        LinkedList documentList = new LinkedList();
        if (classNames == null || classNames.length == 0) {
            documentList.addAll(this.documentFinder.getDocumentsFromProcess(context.getProcessId(), new String[0]));
        } else {
            for (String className : classNames) {
                if (!StringUtils.isNotBlank((String)className)) continue;
                documentList.addAll(this.documentFinder.getDocumentsFromProcessAndClass(context.getProcessId(), className, new String[0]));
            }
        }
        return (Long[])documentList.stream().map(WfDocument::getId).toArray(Long[]::new);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public Long latestFileId(Long documentId, String className) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(className, new String[0]);
        return this.documentFinder.getDocument(documentId, documentClass.getId()).getFile().getId();
    }
}

