/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.duals;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.documents.duals.parameters.SynchronizeIndexesFromVariablesParameters;
import com.suncode.cuf.common.utils.LogUtils;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class SynchronizeIndexesFromVariables {
    private static final Logger log = LoggerFactory.getLogger(SynchronizeIndexesFromVariables.class);
    @Autowired
    private CUFCommonDocumentService cufDocumentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("synchro-indexes-from-variables")).name("dual-app-set.synchronize-indexes-from-variables.name")).description("dual-app-set.synchronize-indexes-from-variables.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/8IPK")).icon((Icon)SilkIconPack.APPLICATION)).contextVariable().id("documentName").name("dual-app-set.synchronize-indexes-from-variables.documentName.name").description("dual-app-set.synchronize-indexes-from-variables.documentName.desc").type((Type)Types.STRING).create().contextVariable().id("documentId").name("dual-app-set.synchronize-indexes-from-variables.documentId.name").description("dual-app-set.synchronize-indexes-from-variables.documentId.desc").type((Type)Types.INTEGER).create().parameter().id("documentsSourceForUpdatingIndexes").name("dual-app-set.synchronize-indexes-from-variables.documentsSourceForUpdatingIndexes.name").description("dual-app-set.synchronize-indexes-from-variables.documentsSourceForUpdatingIndexes.desc").type((Type)Types.STRING).defaultValue((Object)"PROCESS").create()).parameter().id("docClass").name("dual-app-set.synchronize-indexes-from-variables.docClass.name").description("dual-app-set.synchronize-indexes-from-variables.docClass.desc").type((Type)Types.STRING).optional().create()).parameter().id("indexes").name("dual-app-set.synchronize-indexes-from-variables.indexes.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("variables").name("dual-app-set.synchronize-indexes-from-variables.variables.name").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("indexesToSetFromValues").name("dual-app-set.synchronize-indexes-from-variables.indexesToSetFromValues.name").description("dual-app-set.synchronize-indexes-from-variables.indexesToSetFromValues.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("values").name("dual-app-set.synchronize-indexes-from-variables.values.name").description("dual-app-set.synchronize-indexes-from-variables.values.desc").type((Type)Types.FUNCTION_ARRAY).optional().create()).parameter().id("fileIds").name("dual-app-set.synchronize-indexes-from-variables.fileIds.name").description("dual-app-set.synchronize-indexes-from-variables.fileIds.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("documentIds").name("dual-app-set.synchronize-indexes-from-variables.documentIds.name").description("dual-app-set.synchronize-indexes-from-variables.documentIds.desc").type((Type)Types.INTEGER_ARRAY).optional().create();
    }

    public void execute(Parameters parameters, ApplicationContext context, ContextVariables contextVariables) {
        this.setIndexesInDocuments(parameters, (WorkflowContext)context, contextVariables);
    }

    public void set(Parameters parameters, AcceptanceContext context, ContextVariables contextVariables) {
        this.setIndexesInDocuments(parameters, (WorkflowContext)context, contextVariables);
    }

    private void setIndexesInDocuments(Parameters parameters, WorkflowContext context, ContextVariables contextVariables) {
        List<WfDocument> documents;
        SynchronizeIndexesFromVariablesParameters applicationSetterParameters = new SynchronizeIndexesFromVariablesParameters(parameters);
        long documentClassId = this.cufDocumentService.getDocumentClassID(applicationSetterParameters.getDocClass());
        switch (applicationSetterParameters.getDocumentsSourceForUpdatingIndexes()) {
            case "PROCESS": {
                documents = this.getDocumentsAttachedToProcess(documentClassId, context);
                break;
            }
            case "FILEIDS": {
                documents = this.getDocumentsByFileIds(applicationSetterParameters.getFileIds(), documentClassId);
                break;
            }
            case "DOCUMENTIDS": {
                documents = this.getDocumentsByDocumentIdsAndDocumentClassId(applicationSetterParameters.getDocumentIds(), documentClassId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid documents source for updating indexes: " + applicationSetterParameters.getDocumentsSourceForUpdatingIndexes());
            }
        }
        LogUtils logUtils = new LogUtils(context);
        documents.forEach(document -> this.updateIndexes((WfDocument)document, applicationSetterParameters, contextVariables, logUtils));
    }

    private List<WfDocument> getDocumentsAttachedToProcess(long documentClassId, WorkflowContext context) {
        return this.documentFinder.getDocumentsFromProcess(context.getProcessId(), new String[]{"documentClass"}).stream().filter(document -> document.getDocumentClassId().equals(documentClassId)).collect(Collectors.toList());
    }

    private List<WfDocument> getDocumentsByFileIds(Integer[] fileIds, long documentClassId) {
        return Arrays.stream(fileIds).map(fileId -> {
            WfDocument document = this.documentFinder.findByFileId(Long.valueOf(fileId.intValue()), Long.valueOf(documentClassId));
            if (document == null) {
                throw new RuntimeException("No document found for file id " + fileId);
            }
            return document;
        }).collect(Collectors.toList());
    }

    private List<WfDocument> getDocumentsByDocumentIdsAndDocumentClassId(Integer[] documentIds, long documentClassId) {
        return Arrays.stream(documentIds).map(documentId -> {
            WfDocument document = this.documentFinder.getDocument(Long.valueOf(documentId.intValue()), Long.valueOf(documentClassId));
            if (document == null) {
                throw new RuntimeException("No document found for document id " + documentId + " and document class id " + documentClassId);
            }
            return document;
        }).collect(Collectors.toList());
    }

    private void updateIndexes(WfDocument document, SynchronizeIndexesFromVariablesParameters applicationSetterParameters, ContextVariables contextVariables, LogUtils logUtils) {
        contextVariables.set("documentName", (Object)document.getFile().getFileName());
        contextVariables.set("documentId", (Object)document.getId());
        if (applicationSetterParameters.getIndexesMappingByVariables().size() > 0) {
            this.updateIndexesFromVariables(document, applicationSetterParameters.getIndexesMappingByVariables());
        }
        if (applicationSetterParameters.getIndexesMappingByValues().size() > 0) {
            this.updateIndexesFromValues(document, applicationSetterParameters.getIndexesMappingByValues(), logUtils);
        }
        this.documentService.updateDocument(document);
    }

    private void updateIndexesFromValues(WfDocument document, Map<String, FunctionCall> indexesMappingByValues, LogUtils logUtils) {
        AtomicInteger indexNumber = new AtomicInteger(0);
        indexesMappingByValues.forEach((key, value) -> {
            logUtils.disableLoggingIfLimitReached(indexNumber.get());
            logUtils.debug("Update index " + indexNumber.getAndIncrement());
            this.updateIndex(document, (String)key, value.call());
        });
    }

    private void updateIndexesFromVariables(WfDocument document, Map<String, Variable> indexesMappingByVariables) {
        indexesMappingByVariables.forEach((key, value) -> this.updateIndex(document, (String)key, value.getValueAsBasicType()));
    }

    private void updateIndex(WfDocument document, String indexName, Object indexValue) {
        Long indexId = this.cufDocumentService.getDocumentClassIndexID(indexName, document.getDocumentClassId());
        IndexInfo indexInfo = document.getIndexById(indexId);
        if (indexInfo == null) {
            log.warn("Index name " + indexName + "not found in document Id " + document.getId());
            return;
        }
        if (indexValue instanceof LocalDate) {
            indexValue = indexValue.toString();
        } else if (indexValue instanceof LocalDateTime) {
            indexValue = ((LocalDateTime)indexValue).toString("YYYY-MM-dd HH:mm:ss");
        } else if (indexValue instanceof Date) {
            indexValue = new DateTime(indexValue).toLocalDateTime().toString("YYYY-MM-dd HH:mm:ss");
        }
        indexInfo.setValue(indexValue);
    }
}

