/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.applications;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Application
public class CopyMoveDocumentApp {
    private static final Logger log = LoggerFactory.getLogger(CopyMoveDocumentApp.class);
    private static final String DEFAULT_MODE = "COPYING";
    private static final String DEFAULT_FILTER_TYPE = "DOCIDS";
    @Autowired
    private CUFCommonDocumentService cufDocumentService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("copy-move-document-app")).name("application.copy-move-document-app.name")).description("application.copy-move-document-app.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/84PK")).icon((Icon)SilkIconPack.PAGE_COPY)).parameter().id("doc-class-src").name("application.copy-move-document-app.param.doc-class-src.name").description("application.copy-move-document-app.param.doc-class-src.desc").type((Type)Types.STRING).create()).parameter().id("doc-class-to").name("application.copy-move-document-app.param.doc-class-to.name").description("application.copy-move-document-app.param.doc-class-to.desc").type((Type)Types.STRING).create()).parameter().id("doc-ids").name("application.copy-move-document-app.param.doc-ids.name").description("application.copy-move-document-app.param.doc-ids.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("mode").name("application.copy-move-document-app.param.mode.name").description("application.copy-move-document-app.param.mode.desc").defaultValue((Object)DEFAULT_MODE).type((Type)Types.STRING).create()).parameter().id("attach-to-process").name("application.copy-move-document-app.param.attach-to-process.name").description("application.copy-move-document-app.param.attach-to-process.desc").defaultValue((Object)true).type((Type)Types.BOOLEAN).create()).parameter().id("save-as-new-version").name("application.copy-move-document-app.param.add-new-version.name").description("application.copy-move-document-app.param.add-new-version.desc").defaultValue((Object)Boolean.FALSE).type((Type)Types.BOOLEAN).optional().create()).parameter().id("index-id-class-from").name("application.copy-move-document-app.param.index-id-class-from.name").description("application.copy-move-document-app.param.index-id-class-from.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("index-id-class-to").name("application.copy-move-document-app.param.index-id-class-to.name").description("application.copy-move-document-app.param.index-id-class-to.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("execute-actions").name("application.copy-move-document-app.param.execute-actions.name").description("application.copy-move-document-app.param.execute-actions.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("new-version-only").name("application.copy-move-document-app.param.new-version-only.name").description("application.copy-move-document-app.param.new-version-only.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("filter-index-name").name("application.copy-move-document-app.param.filter-index-name.name").description("application.copy-move-document-app.param.filter-index-name.desc").optional().type((Type)Types.STRING_ARRAY).create()).parameter().id("filter-index-value").name("application.copy-move-document-app.param.filter-index-value.name").description("application.copy-move-document-app.param.filter-index-value.desc").optional().type((Type)Types.STRING_ARRAY).create()).parameter().id("filter-type").name("application.copy-move-document-app.param.filter-type.name").description("application.copy-move-document-app.param.filter-type.desc").defaultValue((Object)DEFAULT_FILTER_TYPE).type((Type)Types.STRING).create();
    }

    public void execute(final ApplicationContext context, final @Param(value="doc-class-src") String docClassSrc, final @Param(value="doc-class-to") String docClassTo, @Param(value="doc-ids") String[] docIds, final @Param(value="mode") String mode, final @Param(value="attach-to-process") Boolean attachToProcess, @Param(value="index-id-class-to") String[] indexIdsTo, @Param(value="index-id-class-from") String[] indexIdsFrom, final @Param(value="save-as-new-version") Boolean newVersion, final @Param(value="execute-actions") Boolean executeActions, final @Param(value="new-version-only") Boolean newVersionOnly, @Param(value="filter-type") String filterType, @PairedParam(key="filter-index-name", value="filter-index-value") Map<String, String> indexFilter, UserInfo userInfo) throws IllegalArgumentException {
        Long docClassToId;
        Long docClassFromId;
        try {
            docClassFromId = this.cufDocumentService.getDocumentClassID(docClassSrc);
            docClassToId = this.cufDocumentService.getDocumentClassID(docClassTo);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Document class names/ids to copy/move are not valid!");
        }
        final String userName = userInfo == null ? SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME") : userInfo.getUserName();
        log.info("MODE:\t" + mode + "\nFrom class:\t" + docClassSrc + "\nTo class:\t" + docClassTo + "\nBy user:\t" + userName);
        List docsFromProcess = this.documentFinder.getDocumentsFromProcess(context.getProcessId(), new String[]{"documentClass"});
        List<Long> docsToCopyMoveIds = this.getDocIDs(docIds);
        log.info("Ids of the documents to be copied/transferred: " + Arrays.toString(docsToCopyMoveIds.toArray()));
        for (final WfDocument document : docsFromProcess) {
            if (document.getDocumentClassId().equals(docClassFromId) && Boolean.TRUE.equals(this.checkFilters(filterType, document, indexFilter, docsToCopyMoveIds))) {
                log.info("Dzialam na dokumencie o id: " + document.getId());
                final Map<Long, Object> idx = this.copingIndexes(document, indexIdsFrom, indexIdsTo, docClassFromId, docClassToId);
                PlatformTransactionManager hibernateTransactionManager = TransactionManagerFactory.getHibernateTransactionManager();
                TransactionTemplate template = new TransactionTemplate(hibernateTransactionManager);
                template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        WfFile wfFile = CopyMoveDocumentApp.this.fileService.getFile(Long.valueOf(document.getFile().getId()), new String[]{"version"});
                        List wfFileAllVersion = CopyMoveDocumentApp.this.getAllFileVersions(wfFile, newVersionOnly);
                        try {
                            log.info("Creating a new document");
                            WfDocument firstNewDoc = CopyMoveDocumentApp.this.addDocument(docClassToId, (WfFile)wfFileAllVersion.get(wfFileAllVersion.size() - 1), context.getProcessId(), idx, attachToProcess, newVersion, docClassSrc, docClassTo);
                            Long tempDocId = firstNewDoc.getFile().getId();
                            for (int i = wfFileAllVersion.size() - 2; i >= 0; --i) {
                                log.info("Attaching document version");
                                tempDocId = CopyMoveDocumentApp.this.addNextVersionDoc(context.getProcessId(), attachToProcess, newVersion, docClassToId, userName, idx, (WfFile)wfFileAllVersion.get(i), tempDocId, docClassSrc, docClassTo);
                            }
                            if (Boolean.TRUE.equals(executeActions)) {
                                CopyMoveDocumentApp.this.documentClassActionService.executeArchiveActions(firstNewDoc, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        if (!mode.equalsIgnoreCase(CopyMoveDocumentApp.DEFAULT_MODE)) {
                            log.info("Deleting document with id: " + document.getId() + " from class with id " + document.getDocumentClassId());
                            CopyMoveDocumentApp.this.documentService.deleteAllDocumentVersions(document);
                            if (Boolean.TRUE.equals(executeActions)) {
                                CopyMoveDocumentApp.this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.DELETE_DOCUMENT_FROM_ARCHIVE);
                            }
                        }
                    }
                });
                continue;
            }
            log.info("Pomijam dokument o id: " + document.getId());
        }
    }

    private Boolean checkFilters(String filterType, WfDocument document, Map<String, String> indexFilter, List<Long> docsToCopyMoveIds) {
        if (filterType.equalsIgnoreCase(DEFAULT_FILTER_TYPE)) {
            return docsToCopyMoveIds.isEmpty() || docsToCopyMoveIds.contains(document.getId());
        }
        return this.checkIndexFilter(document, indexFilter);
    }

    private Boolean checkIndexFilter(WfDocument document, Map<String, String> indexFilter) {
        if (indexFilter.isEmpty()) {
            return true;
        }
        return indexFilter.entrySet().stream().allMatch(entry -> {
            IndexInfo index = document.getIndexByName((String)entry.getKey());
            if (index == null) {
                throw new IllegalArgumentException("Index not existing:\t" + (String)entry.getKey() + " Document: " + document.getFile().getFileName());
            }
            return this.compareIndexValue((Map.Entry<String, String>)entry, index);
        });
    }

    private boolean compareIndexValue(Map.Entry<String, String> entry, IndexInfo index) {
        if (index.getType() == IndexType.DATE) {
            LocalDate parsedDate = (LocalDate)index.getType().parse(entry.getValue());
            Date indexDate = (Date)index.getValue();
            if (parsedDate == null && indexDate == null) {
                return true;
            }
            if (parsedDate == null || indexDate == null) {
                return false;
            }
            return parsedDate.toDate().equals(indexDate);
        }
        if (index.getType() == IndexType.DATETIME) {
            LocalDateTime parsedDateTime = (LocalDateTime)index.getType().parse(entry.getValue());
            Timestamp indexTimestamp = (Timestamp)index.getValue();
            if (parsedDateTime == null && indexTimestamp == null) {
                return true;
            }
            if (parsedDateTime == null || indexTimestamp == null) {
                return false;
            }
            return indexTimestamp.getTime() == parsedDateTime.toDateTime().getMillis();
        }
        Object parsedObj = index.getType().parse(entry.getValue());
        Object indexObj = index.getValue();
        if (parsedObj == null && indexObj == null) {
            return true;
        }
        if (parsedObj == null || indexObj == null) {
            return false;
        }
        return indexObj.equals(parsedObj);
    }

    private List<WfFile> getAllFileVersions(WfFile wfFile, Boolean newVersionOnly) {
        ArrayList<WfFile> wfFileAllVersions = new ArrayList<WfFile>();
        if (Boolean.TRUE.equals(newVersionOnly)) {
            wfFileAllVersions.add(wfFile);
            return wfFileAllVersions;
        }
        while (wfFile != null) {
            wfFileAllVersions.add(wfFile);
            Hibernate.initialize((Object)wfFile.getVersion().getParentFile());
            wfFile = wfFile.getVersion().getParentFile();
        }
        return wfFileAllVersions;
    }

    private Long addNextVersionDoc(String processId, Boolean attachToProcess, Boolean newVersion, Long docClassToId, String userName, Map<Long, Object> idx, WfFile wfFile, Long tempDocId, String docClassSrc, String docClassTo) throws Exception {
        this.fileService.checkOut(tempDocId, userName);
        DocumentDefinition fileDefinition = this.createNewDocumentDefinition(docClassToId, wfFile, processId, idx, attachToProcess, newVersion, docClassSrc, docClassTo);
        return this.fileService.checkIn(fileDefinition, tempDocId, wfFile.getVersion().getComment());
    }

    private Map<Long, Object> copingIndexes(WfDocument document, String[] indexIdsFrom, String[] indexIdsTo, Long docClassFromId, Long docClassToId) {
        HashMap<Long, Object> idx = new HashMap<Long, Object>();
        if (indexIdsFrom != null && indexIdsTo != null && indexIdsFrom.length == indexIdsTo.length && indexIdsFrom.length > 0) {
            for (int index = 0; index < indexIdsFrom.length; ++index) {
                if (StringUtils.isBlank((String)indexIdsFrom[index]) || StringUtils.isBlank((String)indexIdsTo[index])) continue;
                Long idIndexesFrom = this.cufDocumentService.getDocumentClassIndexID(indexIdsFrom[index], docClassFromId);
                IndexInfo indexesObj = document.getIndexById(idIndexesFrom);
                Long idIndexesTo = this.cufDocumentService.getDocumentClassIndexID(indexIdsTo[index], docClassToId);
                if (indexesObj.getValue() == null) continue;
                idx.put(idIndexesTo, indexesObj.getValue());
            }
        } else {
            log.info("No indexes or incorrect length ");
        }
        return idx;
    }

    private WfDocument addDocument(Long docClassToId, WfFile wfFile, String processId, Map<Long, Object> idx, Boolean attachToProcess, Boolean newVersion, String docClassSrc, String docClassTo) {
        DocumentDefinition definition = this.createNewDocumentDefinition(docClassToId, wfFile, processId, idx, attachToProcess, newVersion, docClassSrc, docClassTo);
        return this.documentService.addDocument(definition);
    }

    private DocumentDefinition createNewDocumentDefinition(Long docClassToId, WfFile wfFile, String processId, Map<Long, Object> idx, Boolean attachToProcess, Boolean newVersion, String docClassSrc, String docClassTo) {
        InputStream is = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(docClassToId);
        definition.setFileName(wfFile.getFileName());
        definition.setUserName(wfFile.getUploader());
        if (wfFile.getDescription().equals(docClassSrc)) {
            definition.setDescription(docClassTo);
        } else {
            definition.setDescription(wfFile.getDescription());
        }
        if (!idx.isEmpty()) {
            definition.setIndexes(idx);
        }
        definition.setInputStream(is);
        if (Boolean.TRUE.equals(attachToProcess)) {
            definition.setProcessId(processId);
        }
        definition.setSaveAsNewVersion(newVersion.booleanValue());
        return definition;
    }

    private List<Long> getDocIDs(String[] docIds) throws IllegalArgumentException {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            for (String docId : docIds) {
                long parsedDocId;
                if (StringUtils.isBlank((String)docId) || (parsedDocId = Long.parseLong(docId)) <= 0L) continue;
                log.info("Adding document id to the list: " + parsedDocId);
                result.add(parsedDocId);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Documents ids to copy/move are not valid!");
        }
        return result;
    }
}

