/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.documents.DocumentClassDto;
import com.suncode.cuf.common.documents.DocumentClassIndexDto;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.PaginatedList;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CUFCommonDocumentServiceImpl
implements CUFCommonDocumentService {
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private TranslatorService translator;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Override
    public CountedResult<DocumentClassDto> getDocumentClasses(String query, Integer start, Integer limit) {
        DetachedCriteria dc = DetachedCriteria.forClass(DocumentClass.class);
        if (StringUtils.isNumeric((CharSequence)query)) {
            DocumentClassDto documentClassDto = this.getDocumentClassDtoFromId(query);
            return new CountedResult(1L, new ArrayList<DocumentClassDto>(Arrays.asList(documentClassDto)));
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            dc.add(Restrictions.ilike((String)"name", (Object)("%" + query + "%")));
        }
        CountedResult documentClasses = this.docClassService.getCountedResult(dc, Pagination.create((Sorter)new Sorter("name"), (Integer)start, (Integer)limit));
        return this.convertDocClassToDto((CountedResult<DocumentClass>)documentClasses);
    }

    @Override
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexes(String className, String query, Integer start, Integer limit) {
        Long docClassId = this.getDocumentClassID(className);
        List<DocumentClassIndex> indexes = this.documentClassIndexFinder.findByDocumentClass(docClassId, new Sorter("name"));
        if (StringUtils.isNotBlank((CharSequence)query)) {
            indexes = this.findDocumentClassIndexes(indexes, query);
        }
        PaginatedList paginatedIndexes = new PaginatedList(indexes, limit);
        List indexesRange = paginatedIndexes.getRange(start);
        return new CountedResult((long)indexes.size(), this.convertDocIndexToDto(indexesRange));
    }

    @Override
    public Long getDocumentClassID(String classNameOrID) {
        DocumentClass documentClass = this.docClassService.getDocumentClass(classNameOrID, new String[0]);
        return documentClass == null ? Long.parseLong(classNameOrID) : documentClass.getId();
    }

    @Override
    public Long getDocumentClassIndexID(String IndexName, Long docClassId) {
        List indexes = this.documentClassIndexFinder.findByDocumentClass(docClassId, new Sorter("name"));
        for (DocumentClassIndex documentClassIndex : indexes) {
            if (!documentClassIndex.getName().equalsIgnoreCase(IndexName)) continue;
            return documentClassIndex.getId();
        }
        return Long.parseLong(IndexName);
    }

    @Override
    public List<DocumentClass> getAllDocClasses() {
        return this.docClassService.getAll(new String[0]);
    }

    @Override
    public String getDocumentClassName(Long classId) {
        DocumentClass temp = (DocumentClass)this.docClassService.get((Serializable)classId);
        return temp == null ? Long.toString(classId) : temp.getName();
    }

    @Override
    public String[] getIndexesNamesFromIds(String className, String[] indexesIds) {
        Long docClassId = this.getDocumentClassID(className);
        List indexes = this.documentClassIndexFinder.findByDocumentClass(docClassId, new Sorter("name"));
        String[] indexesNames = new String[indexesIds.length];
        for (int i = 0; i < indexesIds.length; ++i) {
            indexesNames[i] = this.getIndexNameFromId(indexes, indexesIds[i]);
        }
        return indexesNames;
    }

    @Override
    public Long[] getIndexesIdsFromNames(Long docClassId, String[] indexesNames) {
        List indexes = this.documentClassIndexFinder.findByDocumentClass(docClassId, new Sorter("name"));
        Long[] indexesIds = new Long[indexesNames.length];
        for (int i = 0; i < indexes.size(); ++i) {
            indexesIds[i] = ((DocumentClassIndex)indexes.get(i)).getName().equalsIgnoreCase(indexesNames[i]) ? ((DocumentClassIndex)indexes.get(i)).getId() : Long.valueOf(Long.parseLong(indexesNames[i]));
        }
        return indexesIds;
    }

    @Override
    public List<WfDocument> getDocumentsFromProcess(String processId) {
        return this.documentFinder.getDocumentsFromProcess(processId, new String[]{"documentClass"});
    }

    @Override
    public List<WfDocument> getDocumentsFromProcessWithDocumentClass(String processId, Long documentClassId) {
        List documentsFromProcess = this.documentFinder.getDocumentsFromProcess(processId, new String[]{"documentClass"});
        ArrayList<WfDocument> documentsWithDocumentClass = new ArrayList<WfDocument>();
        for (WfDocument document : documentsFromProcess) {
            if (!document.getDocumentClassId().equals(documentClassId)) continue;
            documentsWithDocumentClass.add(document);
        }
        return documentsWithDocumentClass;
    }

    @Override
    public String getDocumentClassName(String docClassNameOrId) {
        Long docClassId = this.getDocumentClassID(docClassNameOrId);
        return this.getDocumentClassName(docClassId);
    }

    @Override
    public DocumentClassDto getDocumentClassDto(String docClassName) {
        DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = docClassService.getDocumentClass(docClassName, new String[]{"indexes"});
        return DocumentClassDto.fromEntity(documentClass);
    }

    @Override
    public void attachDocumentsToProcess(List<WfDocument> documents, String processId, String userName) {
        for (WfDocument document : documents) {
            this.documentService.attachDocumentToProcess(document, userName, processId, null, true);
        }
    }

    @Override
    public void detachDocumentsFromProcess(List<WfDocument> documents, String processId) {
        for (WfDocument document : documents) {
            this.documentService.detachDocumentFromProcess(document, processId);
        }
    }

    @Override
    public AddDocumentResultMeta addDocumentWithMetaResult(DocumentDefinition definition) {
        return this.documentService.addDocumentWithMetaResult(definition);
    }

    @Override
    public Map<Long, Object> convertIndexes(Map<String, String> indexesMapping, String docClassName) {
        if (indexesMapping == null || indexesMapping.isEmpty()) {
            return null;
        }
        DocumentClass docClass = this.docClassService.getDocumentClass(docClassName, new String[]{"indexes"});
        return docClass.getIndexes().stream().filter(docClassIndex -> indexesMapping.containsKey(docClassIndex.getName())).collect(HashMap::new, (map, docClassIndex) -> map.put(docClassIndex.getId(), indexesMapping.get(docClassIndex.getName())), HashMap::putAll);
    }

    @Override
    public void executeProcessActions(WfDocument document, DocumentEventTypes type, String processId, String activityId, Boolean savedAsNewVersion) {
        this.documentClassActionService.executeProcessActions(document, type, processId, activityId, savedAsNewVersion);
    }

    @Override
    public void executeArchiveActions(WfDocument document, DocumentEventTypes type, Boolean savedAsNewVersion) {
        this.documentClassActionService.executeArchiveActions(document, type, savedAsNewVersion);
    }

    private List<DocumentClassIndex> findDocumentClassIndexes(List<DocumentClassIndex> indexes, String query) {
        return indexes.stream().filter(index -> StringUtils.containsIgnoreCase((CharSequence)index.getName(), (CharSequence)query) || StringUtils.equals((CharSequence)index.getId().toString(), (CharSequence)query)).collect(Collectors.toList());
    }

    private CountedResult<DocumentClassDto> convertDocClassToDto(CountedResult<DocumentClass> documentClasses) {
        List data = documentClasses.getData();
        ArrayList<DocumentClassDto> dtoData = new ArrayList<DocumentClassDto>();
        for (DocumentClass dc : data) {
            DocumentClassDto dto = DocumentClassDto.builder().id(dc.getId()).name(dc.getName()).displayName(dc.getName()).build();
            dtoData.add(dto);
        }
        return new CountedResult(documentClasses.getTotal(), dtoData);
    }

    private List<DocumentClassIndexDto> convertDocIndexToDto(List<DocumentClassIndex> data) {
        return data.stream().map(documentClassIndex -> DocumentClassIndexDto.builder().id(documentClassIndex.getId()).displayName(documentClassIndex.getName()).name(documentClassIndex.getName()).type(this.translator.translate(documentClassIndex.getType().toString().toLowerCase())).build()).collect(Collectors.toList());
    }

    private DocumentClassDto getDocumentClassDtoFromId(String query) {
        DocumentClass documentClass = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(query)));
        if (documentClass == null) {
            return DocumentClassDto.builder().name(query).displayName(query).build();
        }
        return DocumentClassDto.builder().id(documentClass.getId()).name(query).displayName(documentClass.getName()).build();
    }

    private String getIndexNameFromId(List<DocumentClassIndex> indexes, String id) {
        for (DocumentClassIndex index : indexes) {
            if (!Long.toString(index.getId()).equals(id)) continue;
            return index.getName();
        }
        return id;
    }
}

