/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.utils;

import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.filters.BetweenQueryFilter;
import com.suncode.cuf.common.db.filters.LikeQueryFilter;
import com.suncode.cuf.common.db.filters.QueryFilter;
import com.suncode.cuf.common.db.schemas.DataFromDBDefinition;
import com.suncode.cuf.common.db.sorters.QuerySorter;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.SimpleFilter;
import com.suncode.pwfl.search.Sorter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFromDBDefinitionConverter {
    private static final Logger log = LoggerFactory.getLogger(DataFromDBDefinitionConverter.class);

    public static DBQueryConfig convertToDBCfg(DataFromDBDefinition dto) {
        String dbName = dto.getDbName();
        int start = dto.getStart();
        int limit = dto.getLimit();
        String queryKey = dto.getQueryKey();
        Object[] queryParameters = ArrayUtils.isNotEmpty((Object[])dto.getQueryParameters()) || ArrayUtils.isNotEmpty((Object[])dto.getQueryParametersTypes()) ? DataConverter.stringsToObjects(dto.getQueryParameters(), dto.getQueryParametersTypes()) : new Object[]{};
        return DBQueryConfig.builder().dbName(dbName).queryKey(queryKey).queryParams(queryParameters).first(start).max(limit).filters(DataFromDBDefinitionConverter.convertToQueryFilters(dto.getFilters())).sorters(DataFromDBDefinitionConverter.convertToQuerySorters(dto.getSorters())).build();
    }

    public static List<QueryFilter> convertToQueryFilters(List<SimpleFilter> filters) {
        ArrayList<QueryFilter> queryFilters = new ArrayList<QueryFilter>();
        filters.stream().forEach(filter -> {
            if (filter.getOperator() == FilterOperator.BETWEEN) {
                ArrayList value = (ArrayList)filter.getValue();
                Class<?> type = DataFromDBDefinitionConverter.getFilterType(value.get(0), value.get(1));
                Object firstValue = DataFromDBDefinitionConverter.getFirstFilterValue(value.get(0), type);
                Object secondValue = DataFromDBDefinitionConverter.getSecondFilterValue(value.get(1), type);
                queryFilters.add(new BetweenQueryFilter(filter.getProperty(), firstValue, secondValue));
            } else if (filter.getOperator() == FilterOperator.LIKE) {
                queryFilters.add(new LikeQueryFilter(filter.getProperty(), filter.getValue()));
            }
        });
        return queryFilters;
    }

    private static Class<?> getFilterType(Object object, Object object2) {
        if (object instanceof Date || object2 instanceof Date) {
            return Date.class;
        }
        if (object instanceof Integer || object2 instanceof Integer) {
            return Integer.class;
        }
        if (object instanceof Double || object2 instanceof Double) {
            return Double.class;
        }
        throw new IllegalArgumentException("Unknown filter type!");
    }

    private static Object getSecondFilterValue(Object value, Class<?> type) {
        if (type == Date.class) {
            return value == null ? DataFromDBDefinitionConverter.getMaxDate() : value;
        }
        if (type == Integer.class) {
            return value == null ? Integer.valueOf(Integer.MAX_VALUE) : value;
        }
        if (type == Double.class) {
            return value == null ? Double.valueOf(Double.MAX_VALUE) : value;
        }
        throw new IllegalArgumentException("Unknown filter second value!");
    }

    private static Date getMaxDate() {
        String date = "3999-12-31";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("B\u0142ad parsowania maksymalnej daty!");
        }
    }

    private static Object getFirstFilterValue(Object value, Class<?> type) {
        if (type == Date.class) {
            return value == null ? new Date(0L) : value;
        }
        if (type == Integer.class) {
            return value == null ? Integer.valueOf(Integer.MIN_VALUE) : value;
        }
        if (type == Double.class) {
            return value == null ? Double.valueOf(Double.MIN_VALUE) : value;
        }
        throw new IllegalArgumentException("Unknown filter first value!");
    }

    private static List<QuerySorter> convertToQuerySorters(List<Sorter> sorters) {
        return sorters.stream().map(sorter -> new QuerySorter(sorter.getProperty(), sorter.getDirection())).collect(Collectors.toList());
    }
}

