/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.servlets;

import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.PredefinedQueryExecutor;
import com.suncode.cuf.common.db.dto.PredefinedQueryDataDto;
import com.suncode.cuf.common.db.schemas.DataFromDBDefinition;
import com.suncode.cuf.common.db.schemas.ProcessingDataDefinition;
import com.suncode.cuf.common.db.schemas.QueryDefinition;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.cuf.common.db.utils.DataFromDBDefinitionConverter;
import com.suncode.cuf.common.utils.ProcessedData;
import com.suncode.cuf.common.utils.ProcessingDataService;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"actions"})
public class DBController {
    private static final Logger log = LoggerFactory.getLogger(DBController.class);
    @Autowired
    private DBService dbService;
    @Autowired
    private PredefinedQueryExecutor executor;
    @Autowired
    private ProcessingDataService processingDataService;

    @ResponseBody
    @RequestMapping(value={"/data-table-from-db-action/get/{uuid}"}, method={RequestMethod.POST})
    public CountedResult<Map<String, Object>> find(@PathVariable String uuid, @RequestBody DataFromDBDefinition dto) {
        DBQueryConfig dbQueryCfg = DataFromDBDefinitionConverter.convertToDBCfg(dto);
        log.debug("DBQueryConfig : " + dbQueryCfg.toString());
        CountedResult<Map<String, Object>> data = this.dbService.getDataFromQueryAsCountedResult(dbQueryCfg);
        this.processingDataService.cacheData(uuid, data.getData());
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/data-table-from-db-action/processdata/{uuid}"}, method={RequestMethod.POST})
    public ProcessedData processData(@RequestBody ProcessingDataDefinition definition, @PathVariable String uuid) {
        return this.processingDataService.processData(uuid, definition);
    }

    @ResponseBody
    @RequestMapping(value={"/data-table-from-db-action/invalidate/{uuid}"}, method={RequestMethod.POST})
    public void invalidate(@PathVariable String uuid) {
        this.processingDataService.invalidate(uuid);
    }

    @ResponseBody
    @RequestMapping(value={"data/execute"}, method={RequestMethod.POST})
    public String executeQuery(@RequestBody QueryDefinition cqd) {
        DBQueryConfig dbQueryCfg = DBQueryConfig.builder().dbName(cqd.getDbName()).queryKey(cqd.getQueryId()).queryParams(cqd.getQueryParams()).build();
        log.debug("DBQueryConfig: " + dbQueryCfg.toString());
        this.dbService.executeQuery(dbQueryCfg);
        return "OK";
    }

    @ResponseBody
    @RequestMapping(value={"data/get"}, method={RequestMethod.POST})
    public List<Map<String, Object>> getQueryData(@RequestBody PredefinedQueryDataDto data) {
        return this.executor.executeQueryAndReturnData(data.getDatabaseName(), data.getQueryTable(), data.getQueryName(), data.getQueryParams());
    }

    @RequestMapping(value={"/db-aliases-names"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getDataBaseAlias() {
        ArrayList<String> result = new ArrayList<String>();
        List<Alias> alaisList = this.dbService.getDataBaseAliases();
        for (Alias alias : alaisList) {
            result.add(alias.getName());
        }
        Collections.sort(result);
        return result;
    }
}

