/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.services;

import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.cuf.common.db.services.RecordService;
import com.suncode.cuf.common.db.services.SQLQueryService;
import com.suncode.cuf.common.db.utils.MainDBInfo;
import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.SessionUnit;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Conditions;
import com.suncode.dbexplorer.database.query.Order;
import com.suncode.dbexplorer.database.query.Page;
import com.suncode.dbexplorer.database.query.Pagination;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.SQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="dbService")
@Provides(value={DBService.class})
public class DBServiceImpl
implements DBService {
    private static final Logger log = LoggerFactory.getLogger(DBServiceImpl.class);
    DatabaseExplorer databaseExplorer;
    private SQLQueryService queryService;
    private RecordService recordService;

    @Autowired
    public DBServiceImpl(DatabaseExplorer databaseExplorer, SQLQueryService queryService, RecordService recordService) {
        this.databaseExplorer = databaseExplorer;
        this.queryService = queryService;
        this.recordService = recordService;
    }

    @Override
    public List<Alias> getDataBaseAliases() {
        return this.databaseExplorer.getAliasService().getAliases();
    }

    @Override
    public void synchronizeData(String dbName, String dbSchema, String tableName, List<Map<String, Object>> data, String[] keyColumns) {
        Database database = this.databaseExplorer.get(dbName);
        database.withinSession(session -> {
            data.forEach(row -> {
                Record record = this.recordService.getRecord(keyColumns, (Map<String, Object>)row, dbSchema, session, tableName);
                if (record == null) {
                    this.recordService.insertRecord(dbSchema, session, tableName, (Map<String, Object>)row);
                } else {
                    this.recordService.updateRecord(record, (Map<String, Object>)row, session);
                }
            });
            return true;
        });
    }

    @Override
    public void insertData(String dbName, String dbSchema, String tableName, List<Map<String, Object>> data) {
        Database database = this.databaseExplorer.get(dbName);
        database.withinSession(session -> {
            data.forEach(row -> this.recordService.insertRecord(dbSchema, session, tableName, (Map<String, Object>)row));
            return true;
        });
    }

    @Override
    public void upsertData(String dbName, String dbSchema, String tableName, String updateByColumn, List<Map<String, Object>> dataFromDataSource) {
        this.upsertData(dbName, dbSchema, tableName, new String[]{updateByColumn}, dataFromDataSource);
    }

    @Override
    public void upsertData(String dbName, String dbSchema, String tableName, String[] updateByColumns, List<Map<String, Object>> dataFromDataSource) {
        Database database = this.databaseExplorer.get(dbName);
        database.withinSession(session -> {
            dataFromDataSource.forEach(row -> {
                List<Record> records = this.recordService.getRecords(updateByColumns, (Map<String, Object>)row, dbSchema, session, tableName);
                if (records.isEmpty()) {
                    this.recordService.insertRecord(dbSchema, session, tableName, (Map<String, Object>)row);
                } else {
                    records.forEach(record -> {
                        row.entrySet().forEach(entry -> record.set((String)entry.getKey(), entry.getValue()));
                        this.recordService.updateRecord((Record)record, (Map<String, Object>)row, session);
                    });
                }
            });
            return true;
        });
    }

    @Override
    public void overwriteData(String dbName, String dbSchema, String tableName, List<Map<String, Object>> data) {
        Database database = this.databaseExplorer.get(dbName);
        database.withinSession(session -> {
            this.recordService.deleteRecords(dbSchema, session, tableName);
            data.forEach(row -> this.recordService.insertRecord(dbSchema, session, tableName, (Map<String, Object>)row));
            return true;
        });
    }

    @Override
    public List<Map<String, Object>> mergeQueriesAndReturnValues(List<DBQueryConfig> queries) {
        Database database = this.databaseExplorer.get(queries.get(0).getDbName());
        return (List)database.withinSession(session -> {
            SQLQuery sql = this.queryService.formMergedQuery(session, queries);
            List data = sql.list();
            log.debug("Data returned from DB: {}", (Object)data);
            return data;
        });
    }

    @Override
    public List<Map<String, Object>> getDataFromQuery(DBQueryConfig dbQueryCfg) {
        Database database = this.databaseExplorer.get(dbQueryCfg.getDbName());
        return (List)database.withinSession(session -> {
            SQLQuery sql = this.queryService.formReturnQuery(session, dbQueryCfg);
            List data = sql.list();
            log.debug("Data returned from DB: {}", (Object)data);
            return data;
        });
    }

    @Override
    public CountedResult<Map<String, Object>> getDataFromQueryAsCountedResult(DBQueryConfig dbQueryCfg) {
        List<Map<String, Object>> result = this.getDataFromQuery(dbQueryCfg);
        Long total = this.getCount(dbQueryCfg);
        return new CountedResult(total.longValue(), result);
    }

    @Override
    public void executeQuery(DBQueryConfig dbQueryCfg) {
        Database database = this.databaseExplorer.get(dbQueryCfg.getDbName());
        database.withinSession(session -> this.queryService.formExecuteQuery(session, dbQueryCfg).executeUpdate());
    }

    @Override
    public Long getCount(DBQueryConfig dbQueryCfg) {
        Database database = this.databaseExplorer.get(dbQueryCfg.getDbName());
        return (Long)database.withinSession(session -> {
            SQLQuery sql = this.queryService.formCountQuery(session, dbQueryCfg);
            Long count = (Long)sql.uniqueResult();
            log.debug("Data returned from DB: {}", (Object)count);
            return count;
        });
    }

    @Override
    public Page<Record> getRecordsFromTableWithConstraints(String dbName, String tableName, Condition preliminaryConditions, ComponentQueryData queryData) {
        Database database = this.databaseExplorer.get(dbName);
        return (Page)database.withinSession(session -> {
            com.suncode.pwfl.search.Pagination dcPagination = queryData.getPagination();
            Order order = this.getOrder(dcPagination);
            Pagination pagination = new Pagination(dcPagination.getStart() / 19 + 1, dcPagination.getLimit().intValue(), new Order[]{order});
            Condition finalConditions = this.applyInputFilter(session, tableName, preliminaryConditions, queryData.getQuery());
            return finalConditions != null ? session.select().from(tableName).where(finalConditions).page(pagination) : session.select().from(tableName).page(pagination);
        });
    }

    @Override
    public boolean isDbType(String dbName, DatabaseType dbType) {
        Database database = this.databaseExplorer.get(dbName);
        return database.handles(dbType);
    }

    @Override
    public MainDBInfo.DBType getDBType(String dbName) {
        Database database = this.databaseExplorer.get(dbName);
        if (database.handles(DatabaseType.ORACLE)) {
            return MainDBInfo.DBType.ORACLE;
        }
        if (database.handles(DatabaseType.POSTGRES)) {
            return MainDBInfo.DBType.POSTGRESQL;
        }
        if (database.handles(DatabaseType.SQLSERVER)) {
            return MainDBInfo.DBType.MSSQL;
        }
        throw new IllegalArgumentException("Unknown database!");
    }

    @Override
    public String getQuery(final DBQueryConfig dbQueryCfg) {
        Database database = this.databaseExplorer.get(dbQueryCfg.getDbName());
        return (String)database.withinSession((SessionUnit)new SessionUnit<String>(){

            public String doWork(DatabaseSession session) throws Exception {
                return DBServiceImpl.this.queryService.getQueryFromDB(session, dbQueryCfg);
            }
        });
    }

    @Override
    public Map<String, String> getTableSchema(String dbName, String dbSchema, String tableName) {
        return this.databaseExplorer.get(dbName).getSchema(dbSchema).getTable(tableName).getColumns().stream().collect(Collectors.toMap(ColumnSchema::getName, columnSchema -> columnSchema.getType().getName()));
    }

    private Order getOrder(com.suncode.pwfl.search.Pagination dcPagination) {
        Order.OrderType orderType = null;
        Sorter sorter = dcPagination.getSorter();
        orderType = sorter.getDirection() == SortDirection.ASC ? Order.OrderType.ASC : Order.OrderType.DESC;
        Order order = new Order(sorter.getProperty(), orderType);
        return order;
    }

    private Condition applyInputFilter(DatabaseSession session, String tableName, Condition preliminaryConditions, String input) {
        Condition finalConditions = null;
        if (StringUtils.hasText((String)input)) {
            Set columnsSet = session.getDatabase().getSchema().getTable(tableName).getColumnNames();
            String[] columns = columnsSet.toArray(new String[columnsSet.size()]);
            Condition[] filterConditionsArray = new Condition[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                filterConditionsArray[i] = Conditions.ilike((String)columns[i], (String)input);
            }
            Condition filterConditions = Conditions.or((Condition[])filterConditionsArray);
            finalConditions = preliminaryConditions != null ? Conditions.and((Condition[])new Condition[]{preliminaryConditions, filterConditions}) : filterConditions;
        } else {
            finalConditions = preliminaryConditions;
        }
        return finalConditions;
    }
}

