/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.datachoosers;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.db.datachoosers.utils.ConditionGenerator;
import com.suncode.cuf.common.db.datachoosers.utils.ConstraintValidation;
import com.suncode.cuf.common.db.datachoosers.utils.DCConverter;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Page;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class ConstraintBasedDataChooser {
    private static final Logger log = LoggerFactory.getLogger(ConstraintBasedDataChooser.class);
    @Autowired
    DBService dbService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("constraint-based-datachooser")).name("db.datachooser.constraint-based.name")).description("db.datachooser.constraint-based.desc")).category(new Category[]{Categories.DATABASE})).documentationLink("confluence/x/b4TK")).icon((Icon)SilkIconPack.DATABASE_LIGHTNING)).parameter().id("dbName").name("defaults.db.db-conf.name").description("defaults.db.db-conf.desc").type((Type)Types.STRING).create()).parameter().id("table").name("db.datachooser.constraint-based.table_param.name").description("db.datachooser.constraint-based.table_param.desc").type((Type)Types.STRING).create()).parameter().id("constraintAndParams").name("db.datachooser.constraint-based.constraint_and_params.name").description("db.datachooser.constraint-based.constraint_and_params.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("constraintOrParams").name("db.datachooser.constraint-based.constraint_or_params.name").description("db.datachooser.constraint-based.constraint_or_params.desc").type((Type)Types.STRING_ARRAY).optional().create()).enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, @Param String dbName, @Param String table, @Param String[] constraintAndParams, @Param String[] constraintOrParams) {
        try {
            ConstraintValidation.validateConstraints(constraintAndParams, constraintOrParams);
            ConditionGenerator conditionGenerator = new ConditionGenerator(constraintAndParams, constraintOrParams, contextMap);
            Condition conditions = conditionGenerator.generateConditions();
            Page<Record> records = this.dbService.getRecordsFromTableWithConstraints(dbName, table, conditions, queryData);
            DCConverter.convertPageRecordsToDCResult(records, result);
        }
        catch (Exception e) {
            log.error("Datachooser execution error: ", (Throwable)e);
        }
    }
}

