PWE.integrationComponent.registerFormAction( 'set-seqnumber', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        form.addField("format");
        form.addField("sequenceName");
        form.addField("targetVariable");
        form.addField("specialCharacters");
        
        if (options.destination != "BUTTON") {
            form.addCombobox({
                id: "executeTypes",
                values: [
                    { id: "UPDATING_VARIABLES", display: CUFCommon.t('action.set-variables.execute-type.updating-variables') },
                    { id: "CONDITIONAL_EXECUTE", display: CUFCommon.t('action.set-variables.execute-type.conditional-execute') }
                ],
                listeners: {
                    change: function (value) {
                        var fullValue = form.getValue("executeTypes");      
                        if (fullValue.indexOf("UPDATING_VARIABLES") > -1) {
                            form.show("updatingVariables");
                            form.setNotEmpty("updatingVariables", true);
                        }
                        else {
                            form.resetArray("updatingVariables");
                            form.hide("updatingVariables");
                            form.setNotEmpty("updatingVariables", false);
                        }
                    }
                },
                notEmpty: true
            });
            form.addField({
                id: "updatingVariables",
                notEmpty: true
            });
            if (!(form.getValue("executeTypes").indexOf("UPDATING_VARIABLES") > -1)) {
                form.resetArray("updatingVariables");
                form.hide("updatingVariables");
                form.setNotEmpty("updatingVariables", false);
            }
        }
    },
    validateForm: function(api){
        return formatCheck(api);
    }

});

PWE.integrationComponent.registerApplication( 'sequenced-no-gen', {
    apiVersion : 2,
    buildForm: function( form , options ) {
        form.addField("format");
        form.addField("sequenceName");
        form.addField("targetVariable");
        form.addField("specialCharacters");
        form.addField({
            id: "commentError",
            hidden: true
        });
        if(form.getValue("commentError")){
            form.show("commentError");
        }
    },
    validateForm: function(api){
        return formatCheck(api);
    }

});

PWE.integrationComponent.registerVariablesSetter( 'sequenced-no-gen', {
    apiVersion : 2,
    buildForm: function( form , options ) {
        form.addField("format");
        form.addField("sequenceName");
        form.addField("targetVariable");
        form.addField("specialCharacters");
        form.addField({
            id: "commentError",
            hidden: true
        });
        if(form.getValue("commentError")){
            form.show("commentError");
        }
    },
    validateForm: function(api){
        return formatCheck(api);
    }

});

function formatCheck(api){
    if (!api.hasVariableValue("format") && !api.hasFunctionValue("format")){
        if (!/\[N[1-9][0-9]*\]/.test(api.getValue("format"))){
            api.markError("format");
            api.showErrorMessage(CUFCommon.t("errors.sequenced-no-gen.wrong-format"));
            return false;
        }
    }
    return true;
}