PWE.integrationComponent.registerSystemFunction('TableStore.addRecord', [{
    type: 'string',
    id: 'tableStoreStr',
}, {
    type: 'string[]',
    id: 'fieldIds',
}, {
    type: 'string[]',
    id: 'values',
}], {
    apiVersion: 2,
    buildForm: function(form, options) {
        form.addField('tableStoreStr');
        var table = form.addTable('fields');
        table.addField('fieldIds');
        table.addField('values');
    }
});

PWE.integrationComponent.registerSystemFunction('TableStore.create', [{
    type: 'variable[]',
    id: 'variables',
}], {
    apiVersion: 2,
    validateForm: function(api) {
		var variables = api.getValue('variables');
		var errors = [];
		variables.forEach(function(variable, i) {
			if (!api.hasVariableArrayValue('variables', i)) {
				errors.push(i);
			}
		});
		if (errors.length > 0) {
			errors.forEach(function(i) {
				api.markError('variables', i);
			});
			api.showErrorMessage(CUFCommon.t('form-valid-value-must-be-a-variable-array'));
			return false;
		}
		return true;
	}
});

PWE.integrationComponent.registerSystemFunction('TableStore.filter', [{
    type: 'string',
    id: 'tableStoreStr',
}, {
    type: 'string',
    id: 'logicalOperator',
},{
    type: 'string[]',
    id: 'fieldIds',
}, {
    type: 'string[]',
    id: 'operators',
}, {
    type: 'string[]',
    id: 'values',
}], {
    apiVersion: 2,
    buildForm: function(form, options) {
        form.addField('tableStoreStr');
		form.addCombobox({
			id: 'logicalOperator',
			values: [
				{ id: 'and', display: 'AND' },
				{ id: 'or', display: 'OR' }
			], notEmpty: false, optional: false
		});
		if (!form.getValue('logicalOperator')) {			
			form.setValue('logicalOperator', 'and');
		}
        var table = form.addTable('fieldsTable');
        table.addField('fieldIds');
        table.addCombobox({
            id: 'operators',
            values: [
                { id: '=', display: '=' },
                { id: '!=', display: '!=' },
                { id: '<', display: '<' },
                { id: '<=', display: '<=' },
                { id: '>', display: '>' },
                { id: '>=', display: '>=' },
				{ id: 'regex', display: 'regex' }
            ], notEmpty: false, optional: false
		});
        table.addField('values');
    }
});

PWE.integrationComponent.registerSystemFunction('TableStore.setItems', [{
    type: 'string',
    id: 'tableStoreStr',
}, {
    type: 'integer',
    id: 'elementNr',
},{
    type: 'string[]',
    id: 'fieldIds',
},{
    type: 'string[]',
    id: 'values',
}], {
    apiVersion: 2,
    buildForm: function(form, options) {
		form.addField('tableStoreStr');
		form.addField('elementNr');
		var table = form.addTable('fieldsTable');
        table.addField('fieldIds');
		table.addField('values');
	}
});

PWE.integrationComponent.registerSystemFunction('TableStore.addColumn', [{
    type: 'string',
    id: 'tableStoreStr',
},{
    type: 'string',
    id: 'columnId',
},{
    type: 'string',
    id: 'dataType',
}], {
    apiVersion: 2,
    buildForm: function(form, options) {
		form.addField('tableStoreStr');
		form.addField('columnId');
		form.addCombobox({
			id: 'dataType',
			valueField: 'id',
			forceSelection: true,
			values: [{
				id: 'DATE',
				display: CUFCommon.t('default.date-array'),
				description: CUFCommon.t('default.date-array')
			},{
				id: 'FLOAT',
				display: CUFCommon.t('default.float-array'),
				description: CUFCommon.t('default.float-array')
			},{
				id: 'INTEGER',
				display: CUFCommon.t('default.integer-array'),
				description: CUFCommon.t('default.integer-array')
			},{
				id: 'STRING',
				display: CUFCommon.t('default.string-array'),
				description: CUFCommon.t('default.string-array')
			}]
		});
	}
});

PWE.integrationComponent.registerSystemFunction('TableStore.sort', [{
    type: 'string',
    id: 'tableStoreStr',
},{
    type: 'string',
    id: 'columnId',
},{
    type: 'string',
    id: 'sortDirection',
}], {
    apiVersion: 2,
    buildForm: function(form) {
        form.addField('tableStoreStr');
        form.addField('columnId');
        form.addCombobox({
            id: 'sortDirection',
            valueField: 'id',
            values: [{
                id: 'ASC',
                display: CUFCommon.t('table-store.function.sort-direction.asc')
            },{
                id: 'DESC',
                display: CUFCommon.t('table-store.function.sort-direction.desc')
            }]
        });
    }
});
