PWE.integrationComponent.registerFormAction('table-insert-records', {
    apiVersion: 2,
    buildForm: function(form, options) {
		buildForm(form, options, false);
	},
	validateForm: validate
});

PWE.integrationComponent.registerApplication('table-insert-records-app', {
    apiVersion: 2,
    buildForm: function(form, options) {
		buildForm(form, options, true);
	},
	validateForm: validate
});

PWE.integrationComponent.registerVariablesSetter('table-insert-records-app', {
    apiVersion: 2,
    buildForm: function(form, options) {
		buildForm(form, options, true);
	},
	validateForm: validate
});

function buildForm(form, options, addActivityDefId) {
	form.addField('tableStoreToInsert');
	form.addCombobox({
		id: 'mappingType',
		values: [
			{
				id: 'manual',
				display: CUFCommon.t('mappingType.manual.name'),
				description: CUFCommon.t('mappingType.manual.desc')
			},
			{
				id: 'table',
				display: CUFCommon.t('mappingType.table.name'),
				description: CUFCommon.t('mappingType.table.desc')
			},
		],
		value: 'manual',
		listeners: {
			change: function(newValue) {
				switch(newValue) {
					case 'manual': {
						handleManualMapping(form, addActivityDefId);
						break;
					}
					case 'table': {
						handleTableMapping(form, addActivityDefId);
						break;
					}
				}
			}
		}
	});
	var mappingTypeValue = form.getValue('mappingType');
	var isManualMappingType = mappingTypeValue === 'manual';
	if (addActivityDefId) {
		form.addField({ id: 'activityDefId', hidden: isManualMappingType });
		form.setNotEmpty('activityDefId', !isManualMappingType);
	}
	form.addField({ id: 'tableId', hidden: isManualMappingType });
	form.setNotEmpty('tableId', !isManualMappingType);
    var mappingsTable = form.addTable({ id: 'mappingsTable', name: 'Mapping', hidden: !isManualMappingType });
    mappingsTable.addField('mappingIds');
    mappingsTable.addField('mappingValues');
	form.setNotEmpty('mappingIds', isManualMappingType);
	form.setNotEmpty('mappingValues', isManualMappingType);
	form.addField('overwriteData');
}

function handleManualMapping(form, addActivityDefId) {
	if (addActivityDefId) form.hide('activityDefId');
	form.hide('tableId');
	if (addActivityDefId) form.setNotEmpty('activityDefId', false);
	form.setNotEmpty('tableId', false);
	form.setNotEmpty('mappingIds', true);
	form.setNotEmpty('mappingValues', true);
	form.show('mappingsTable');
}

function handleTableMapping(form, addActivityDefId) {
	form.hide('mappingsTable');
	form.setNotEmpty('mappingIds', false);
	form.setNotEmpty('mappingValues', false);
	form.setNotEmpty('tableId', true);
	if (addActivityDefId) form.setNotEmpty('activityDefId', true);
	form.show('tableId');
	if (addActivityDefId) form.show('activityDefId');
}

function validate(api) {
	let staticMappingKeys = getStaticMappingKeys(api);
	let keys = staticMappingKeys.map(item => item.key);
	let duplicateKeys = keys.filter((item, index) => keys.indexOf(item) != index)

	if (duplicateKeys.length > 0) {
		let duplicateKeysIndex = staticMappingKeys.filter( item => duplicateKeys.includes(item.key) )
			.map(item => item.position);

		duplicateKeysIndex.forEach(function(duplicateKey) {
			api.markError('mappingIds', duplicateKey);
		});
		api.showErrorMessage(CUFCommon.t('form-valid-ids-must-be-unique'));
		return false;
	}
	return true;
}

function getStaticMappingKeys(api) {
	let staticMappingKeys = [];
	for(let mappingPosition=0; mappingPosition < api.getArraySize('mappingIds'); mappingPosition++) {

		if(!api.hasFunctionValue('mappingIds', mappingPosition)) {
			staticMappingKeys.push( {
				'key': api.getValue('mappingIds')[mappingPosition],
				'position': mappingPosition
			});
		}
	}
	return staticMappingKeys;
}
