PWE.integrationComponent.registerApplication('run-document-class-action-app', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addCombobox({
            id: "srcAction",
            remote: {
                url: "plugin/com.suncode-cuf-components/docs/classSources",
                fields: [
                    {
                        name: "sourceName",
                        type: "string"
                    },
                    {
                        name: "translationName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-doc-class-action-source.name"),
                    field: "translationName"
                }
            ],
            valueField: "sourceName",
            displayField: "translationName",
            sort: [{
                property: "translationName",
                direction: "ASC"
            }]
        });
        form.addField("documentClasses");
        var classesToCheck = form.getValue("documentClasses");
        if (classesToCheck.length > 0 && !isNaN(classesToCheck[0])){ // sprawdza, czy klasa jest pobierana przez id(liczba) czy przez name
            CufComp.obtainDocClassIdsAndNamesForCombobox('documentClasses',form);
        }
        else{
            form.removeField("documentClasses");
            CufComp.addComboboxClassList('documentClasses', null, form)
        }
    }
});
