PWE.integrationComponent.registerSystemFunction('toJsonObject', null, {
	apiVersion: 2,
	buildForm: function(form) {
		let table = form.addTable({
			tableId: "keysAndValues"
		});
		table.addField({id: "keys", notEmpty: true, optional: false});
		table.addField({id: "values", notEmpty: true, optional: false});
		CufComp.addComboboxJsonDataTypes("types", table, null);
	},
	validateForm: function(api){
		let values = api.getValue("values");
		let types = api.getValue("types");
		for (let indexNumber = 0; indexNumber < values.length; indexNumber++) {
			if (!validateToJsonObjectOrToJsonArrayFunction(api, values[indexNumber], types[indexNumber], indexNumber)) {
				return false
			}
		}
	}
});

PWE.integrationComponent.registerSystemFunction('toJsonArray', null, {
	apiVersion: 2,
	buildForm: function(form) {
		form.addField({id: "values", notEmpty: true, optional: false});
		CufComp.addComboboxJsonDataTypes("type", form, null);
	},
	validateForm: function(api) {
		let values = api.getValue("values");
		let type = api.getValue("type");
		for (let indexNumber = 0; indexNumber < values.length; indexNumber++) {
			if (!validateToJsonObjectOrToJsonArrayFunction(api, values[indexNumber], type, indexNumber)) {
				return false;
			}
		}
	}
});

PWE.integrationComponent.registerSystemFunction('toJsonArrayIterator', null, {
	apiVersion: 2,
	buildForm: function(form) {
		form.addField({id: "function", notEmpty: false, optional: false});
		form.addField({id: "maxTableLength", notEmpty: false, optional: false});
		form.addField({id: "counter", notEmpty: false, optional: false});
		CufComp.addComboboxJsonDataTypes("type", form, null);
	},
	validateForm: function(api) {
		let type = api.getValue("type");
		let functionName = api.getValue("function");
		switch (type) {
			case "STRING":
				if (api.getFunctionReturnType("function") !== "string") {
					api.markError("function");
					api.showErrorMessage(CUFCommon.t("json-functions.form-function-value-must-return-string"));
					return false;
				}
				break;
			case "INTEGER":
				if (api.getFunctionReturnType("function") !== "integer") {
					api.markError("function");
					api.showErrorMessage(CUFCommon.t("json-functions.form-function-value-must-return-integer"));
					return false;
				}
				break;
			case "FLOAT":
				if (api.getFunctionReturnType("function") !== "float") {
					api.markError("function");
					api.showErrorMessage(CUFCommon.t("json-functions.form-function-value-must-return-float"));
					return false;
				}
				break;
			case "BOOLEAN":
				if (api.getFunctionReturnType("function") !== "boolean") {
					api.markError("function");
					api.showErrorMessage(CUFCommon.t("json-functions.form-function-value-must-return-boolean"));
					return false;
				}
				break;
			case "OBJECT":
				if (functionName !== "toJsonObject") {
					api.markError("function");
					api.showErrorMessage(CUFCommon.t("json-functions.form-function-value-must-return-object"));
					return false;
				}
				break;
			case "ARRAY":
				if (functionName !== "toJsonArray" && functionName !== "toJsonArrayIterator") {
					api.markError("function");
					api.showErrorMessage(CUFCommon.t("json-functions.form-function-value-must-return-array"));
					return false;
				}
				break;
		}
		if (api.getVariableType("counter") !== "integer") {
			api.markError("counter");
			api.showErrorMessage(CUFCommon.t("json-functions.form-counter-variable-type-must-be-integer"));
			return false;
		}
	}
});

function validateToJsonObjectOrToJsonArrayFunction(api, value, type, indexNumber) {
	switch (type) {
		case "INTEGER":
			if (isValuesParameterVariableOrFunction(api, indexNumber)) {
				return true;
			}
			if (!validateIntegerField(value)) {
				api.markError("values", indexNumber);
				api.showErrorMessage(CUFCommon.t("json-functions.form-text-value-must-be-integer-type"));
				return false;
			}
			return true;
		case "FLOAT":
			if (isValuesParameterVariableOrFunction(api, indexNumber)) {
				return true;
			}
			if (!validateFloatField(value)) {
				api.markError("values", indexNumber);
				api.showErrorMessage(CUFCommon.t("json-functions.form-text-value-must-be-float-type"));
				return false;
			}
			return true;
		case "BOOLEAN":
			if (isValuesParameterVariableOrFunction(api, indexNumber)) {
				return true;
			}
			if (!validateBooleanField(value)) {
				api.markError("values", indexNumber);
				api.showErrorMessage(CUFCommon.t("json-functions.form-text-value-must-be-boolean-type"));
				return false;
			}
			return true;
		case "OBJECT":
			if (!api.hasFunctionValue("values", indexNumber) || value !== "toJsonObject") {
				api.markError("values", indexNumber);
				api.showErrorMessage(CUFCommon.t("json-functions.form-text-value-must-be-object-type"));
				return false;
			}
			return true;
		case "ARRAY":
			if (!api.hasFunctionValue("values", indexNumber) || (value !== "toJsonArray" &&
				value !== "toJsonArrayIterator" )) {
				api.markError("values", indexNumber);
				api.showErrorMessage(CUFCommon.t("json-functions.form-text-value-must-be-array-type"));
				return false;
			}
			return true;
		default:
			return true;
	}
}

function isValuesParameterVariableOrFunction(api, indexNumber) {
	return api.hasVariableValue("values", indexNumber) || api.hasFunctionValue("values", indexNumber);
}

function validateIntegerField(value) {
	var integerValue = Number(value);
	return !isNaN(integerValue) && Number.isInteger(integerValue);
}

function validateFloatField(value) {
	return !isNaN(Number(value));
}

function validateBooleanField(value) {
	return value.toLowerCase() === "true" || value.toLowerCase() === "false";
}