PWE.integrationComponent.registerSystemFunction('isProcessState', [
	{
		type : 'string',
		id : 'processId',
		array : false
	},
	{
		type : 'string',
		id : 'state',
		array : true
}],
{
	apiVersion : 2,
	buildForm : function( form, options ) {
		form.addField( 'processId' );
		form.addCombobox({
			id: 'state',
			remote: {
				url: "plugin/com.suncode-cuf-components/processes/processStateList",
				fields: [
					{
						name: "processStateName",
						type: "string"
					},
					{
						name: "processState",
						type: "string"
					},
					{
						name: "processStateNumber",
						type: "integer"
					}
				]
			},
			template: [
				{
					label: CUFCommon.t("dpwe-process-state.name"),
					field: "processState"
				}
			],
			valueField: "processState",
			displayField: "processState",
			sort: [{
				property: "processState",
				direction: "ASC"
			}],
			listeners: null,
			forceSelection: false
		});
	}
});