PWE.integrationComponent.registerFormAction( 'find-duplicates-action', {
    apiVersion: 2,
    buildForm: function( form, options ) {
    	if (options.destination != "BUTTON") {
    		form.addField("initExecute");
    	}
    	
        form.addField("variablesToCheck");
        form.addCombobox({
            id : "processesType",
            values : [{id : "ALL", display : CUFCommon.t('validator.processdoc.form.all')},
                      {id : "OPENED", display : CUFCommon.t('validator.processdoc.form.opened')},
                      {id : "CLOSED", display : CUFCommon.t('validator.processdoc.form.closed')}]
        });
        var excludingTable = form.addTable();
        excludingTable.addField("variablesExcludingDuplicates");
        excludingTable.addField("valuesExcludingDuplicates");
        form.addField("caseSensitive");
        form.addField("message");
        form.addField("numberOfDuplicatesFound");
        form.addCombobox({
            id : "duplicatePresentationComboBox",
            value : "BASIC", 
            values : [{id : "NONE", display : CUFCommon.t('validator.processdoc.form.none.display'), description : CUFCommon.t('validator.processdoc.form.none.desc')},
                      {id : "BASIC", display : CUFCommon.t('validator.processdoc.form.basic.display'), description : CUFCommon.t('validator.processdoc.form.basic.desc')},
                      {id : "EXTENDEND", display : CUFCommon.t('validator.processdoc.form.extended.display'), description : CUFCommon.t('validator.processdoc.form.extended.desc')}],
            listeners: {
            	change: function(value) {
            		if (value == 'NONE') {
            			form.hide('dataVariables');
            			form.resetArray('dataVariables');
            			form.hide('isHiddenColumn');
            			form.resetValue('isHiddenColumn');
            			form.hide('save-data-field-set');
            			form.setValue('saveDataToVariables', false);
            			form.resetValue('setDataButtonName');
            			form.hide('addColumnWithProcessName');
            			form.resetValue('addColumnWithProcessName');
						form.hide('addLinkToDocuments');
						form.resetValue('addLinkToDocuments');
						form.hide('addLinkToProcess');
						form.resetValue('addLinkToProcess');
            		} else{
            			form.show('dataVariables');
            			form.show('isHiddenColumn');
            			form.show('save-data-field-set');
            			form.show('addColumnWithProcessName');
            			form.show('addLinkToDocuments');
            			form.show('addLinkToProcess');
            		}
            	}
            }
        });
        var dataTable = form.addTable();
        dataTable.addField("dataVariables");
        dataTable.addField('isHiddenColumn');
        
        var saveDataFieldSet = form.addFieldSet({
        	id: "save-data-field-set",
        	title: CUFCommon.t("action.find-duplicates-action.set-data-field-set")
        });
        saveDataFieldSet.addField({
        	id:"saveDataToVariables",
        	listeners: {
				change: function(value) {
					if (value) {
						form.setNotEmpty('variablesToGetData', true);
						form.show('variablesToGetData');
						form.setNotEmpty('variablesToSetData', true);
						form.show('variablesToSetData');
						form.setNotEmpty('setDataButtonName', true);
						form.show('setDataButtonName');
					} else {
						form.setNotEmpty('variablesToGetData', false);
						form.hide('variablesToGetData');
						form.resetArray('variablesToGetData');
						form.setNotEmpty('variablesToSetData', false);
						form.hide('variablesToSetData');
						form.resetValue('variablesToSetData');
						form.setNotEmpty('setDataButtonName', false);
						form.hide('setDataButtonName');
						form.resetValue('setDataButtonName');
					}
				}
			}
        });
        var setTable = saveDataFieldSet.addTable();
        setTable.addField({id:"variablesToGetData", hidden: true});
        setTable.addField({id:"variablesToSetData", hidden: true});
        saveDataFieldSet.addField({id:"setDataButtonName", hidden: true});
        if (saveDataFieldSet.getValue("saveDataToVariables")){
        	saveDataFieldSet.setNotEmpty('variablesToGetData', true);
        	saveDataFieldSet.show('variablesToGetData');
        	saveDataFieldSet.setNotEmpty('variablesToSetData', true);
        	saveDataFieldSet.show('variablesToSetData');
        	saveDataFieldSet.setNotEmpty('setDataButtonName', true);
        	saveDataFieldSet.show('setDataButtonName');
        }
        form.addField("addColumnWithProcessName");
        form.addField("addLinkToDocuments");
        form.addField("addLinkToProcess");
        if (form.getValue("duplicatePresentationComboBox") == 'NONE') {
			form.hide('dataVariables');
			form.hide('isHiddenColumn');
			form.hide('save-data-field-set');
			form.hide('addColumnWithProcessName');
			form.hide('addLinkToDocuments');
			form.hide('addLinkToProcess');
		} else{
			form.show('dataVariables');
			form.show('isHiddenColumn');
			form.show('save-data-field-set');
			form.show('addColumnWithProcessName');
			form.show('addLinkToDocuments');
			form.show('addLinkToProcess');
		}
    },
    
    validateForm: function(api){
        var error = false;
        var arrayTypes = ["string[]", "integer[]", "float[]", "date[]"];
        for( var i = 0; i < api.getArraySize("variablesToCheck"); i++){
        	if (arrayTypes.indexOf(api.getVariableType("variablesToCheck", i)) > -1){
        		api.markError("variablesToCheck", i);
                error = true;
        	}
        }
        for( var i = 0; i < api.getArraySize("variablesExcludingDuplicates"); i++){
        	if (arrayTypes.indexOf(api.getVariableType("variablesExcludingDuplicates", i)) > -1){
        		api.markError("variablesExcludingDuplicates", i);
                error = true;
        	}
        }
        if (error){
            api.showErrorMessage(CUFCommon.t("default.non-array-type-only"));
            return false;
        }
        if (api.getVariableType("numberOfDuplicatesFound") != "integer" && api.getValue("numberOfDuplicatesFound")){
            api.markError("numberOfDuplicatesFound");
            api.showErrorMessage("Podany typ musi być całkowity");
            return false;
        }
		if(api.getValue( "duplicatePresentationComboBox") != "NONE" && api.getValue( "addColumnWithProcessName") === "" ){
			api.markError("addColumnWithProcessName");
			return false;
		}
    }
});