/**
 * Implementation of generate document
 */
PW.FormActions.create('show-alert', {

	buttonInit: function(button) {
		this.button = button;
	},

	defaultActions: {
		button: function(button) {
			this.getAlertData();
			this.showAlertWindow();
		}
	},

	enable: function() {
		if (!this.button) {
			this.getAlertData();
			this.showAlertWindow();
		}
	},

	getAlertData: function() {
		this.alertType = this.get("alertType");
		this.message = this.get("message");
		this.title = this.get("title");
		this.hideAfter = {};
		if (this.get("hideAfter")) {
			this.hideAfter = { hideAfter: this.get("hideAfter") };
		}
		this.messageService = ServiceFactory.getMessageService();
	},

	showAlertWindow: function() {
		if (this.alertType == "standard") {
			this.displayStandardWindow();
		} else if (this.alertType == "success") {
			this.displaySuccessWindow();
		} else if (this.alertType == "failure") {
			this.displayFailureWindow();
		} else {
			this.displayConfirmationWindow();
		}
	},

	displayStandardWindow: function() {
		this.messageService.show(this.message, this.hideAfter);
	},

	displaySuccessWindow: function() {
		this.messageService.showSuccess(this.message, this.hideAfter);
	},

	displayFailureWindow: function() {
		this.messageService.showFailure(this.message, this.hideAfter);
	},

	displayConfirmationWindow: function() {
		this.messageService.showConfirm({
			title: this.title,
			message: this.message
		});
	}
});