PW.FormActions.create("refresh-datachooser-mappings", {
  defaultActions: {
    button: function(_button) {
      this.refreshMappings();
    },
    dtButton: function(_variable, _newValue, _oldValue) {
      this.refreshMappings();
    }
  },

  enable: function() {
  	if (this.target.type === "FORM") {  		
      this.refreshMappings();
  	}
  },
  
  refreshMappings: function() {
  	var datachoosers = this.getRaw("datachoosers");
  	datachoosers.get().forEach(function(datachooser) {
  	  if (datachooser.syncMappings) {
  	  	if (datachooser.variableSet) {
  	  	  for (var i = 0; i < datachooser.getVariableSet().getRecords().length; i++) {
  	  	  	datachooser.syncMappings(i);
  	  	  }
  	  	} else {
  	  	  datachooser.syncMappings();
  	  	}
  	  } else {
  	  	console.error("Variable with id '" + datachooser.id + "' is not a datachooser!")
  	  }
  	});
  }
});
