var variableSetService = ServiceFactory.getVariableSetService();
var messageService = ServiceFactory.getMessageService();
/**
 * Data table from database action implementation
 */
PW.FormActions.create('data-table-from-db-action', {

	init: function() {
		this.multiVals = this.get("multiVals");
		this.executeAutomapping = this.get("executeAutomapping");
	},
	dtButtonInit: function (button) {
    	this.table = button.getVariableSet();
    	this.filters = [];
    	this.variables = this.readVariables();
    },

    variableSetInit : function(table){
        this.filters = [];
    	this.table = table;
    	this.variables = this.readVariables();
    	this.itemId = 'dataTableButton' + new Date();
    },

    buttonInit: function(button) {
    	this.table = variableSetService.getVariableSet(this.get("dynamicTableId"));
    	this.filters = [];
    	this.variables = this.readVariables();
    },

	readVariables: function() {
		return !this.get("columnsToSet") ? [] : this.get("columnsToSet").map(element => ({
			id: element ? element.getId() : "",
			isArray: element ? element.getType().isArray : false
		}));
	},

    defaultActions: {
    	dtButton: function(button){
			if (MobileService.isMobile()) {
				MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
				return;
			}

    		this.prepareColumnParameters();
			this.showDynamicTableWindow();
        },
    	button: function(button){
			if (MobileService.isMobile()) {
				MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
				return;
			}

    		this.prepareColumnParameters();
			this.showDynamicTableWindow();
        }
    },

    showDynamicTableWindow : function(){
		var uuid = this.generateUuid();
		this.cufWindow = CUF.DataService.showDataWin({
		    query: this.getParams(),
		    type:'webservice',
		    winCfg:{
		        title: this.get("windowName") ? this.get("windowName") : CUFCommon.t('action.datatablefromdb.windowtitle')
		    },
		    columns: this.columnParameters,
		    fields: this.columnIndexes,
		    url: 'plugin/com.suncode-cuf-components/actions/data-table-from-db-action/get/' + uuid,
		    gridCfg:{
		    	tbar: (this.get("moving") && !window.isHistory) ? this.getButtons( uuid ) : [],
		        numbered: this.get("numbered"),
		        checkboxSelection: (this.get("moving") && !window.isHistory),
				selectionType: this.get("multipleRowsSelection") ? 'MULTI' : 'SINGLE',
		        showRowCount: true,
		        pageSize: this.get('pageSize') || 50,
		        rememberSelection: true
		    }
		});
		this.cufWindow.on('close', function() {
		    this.invalidateCache( uuid );
		}, this);
	},

	generateUuid: function() {
		return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
			var r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
			return v.toString(16);
		});
	},

	invalidateCache: function( uuid ) {
	    jQuery.ajax({
            url: 'plugin/com.suncode-cuf-components/actions/data-table-from-db-action/invalidate/' + uuid,
            method: 'POST'
        });
	},

    getButtons: function (uuid) {
        let buttonsArray = [this.createMoveSelectedRowsButton(uuid)];
        if (this.get("multipleRowsSelection")) {
            buttonsArray.push(this.createSelectAllRowsButton(), this.createDeselectAllRowsButton());
        }
        return buttonsArray;
    },

    createMoveSelectedRowsButton: function (uuid) {
        let me = this;
        return {
            text: CUFCommon.t('action.datatablefromdb.moveselected'),
            xtype: 'button',
			style: {
				marginBottom:"10px",
				border:"1px solid #cacccf"
			},
            handler: function () {
                var selected = this.up("grid").getSelectionModel().getSelection();
                if (selected && selected.length > 0 && me.get("columnsToSet")) {
                    FormService.save({
                        success: me.moveSelected,
                        successParams: [selected, uuid],
                        scope: me
                    });
                }
            }
        }
    },

    createSelectAllRowsButton: function () {
        return {
            text: CUFCommon.t('action.datatablefromdb.select-all'),
            xtype: 'button',
			style: {
				marginBottom:"10px",
				border:"1px solid #cacccf"
			},
            handler: function () {
                this.up("grid").getSelectionModel().selectAll();
            }
        }
    },

    createDeselectAllRowsButton: function () {
        return {
            text: CUFCommon.t('action.datatablefromdb.deselect-all'),
            xtype: 'button',
			style: {
				marginBottom:"10px",
				border:"1px solid #cacccf"
			},
            handler: function () {
                this.up("grid").getSelectionModel().clearSelections();
                this.up("grid").getSelectionModel().deselectAll();
            }
        }
    },

	getParams : function() {
		return {
    		filters: [],
    		sorters: [],
    		dbName: this.get("datebaseName"),
    		queryKey: this.get("queryKey"),
    		queryParameters: this.get("queryParameters") || [],
    		queryParametersTypes: this.get("queryParametersTypes") || []
	    }
	},

	moveSelected : function (selected, uuid) {
	    var me = this;
	    me.cufWindow.mask( CUFCommon.t('action.datatablefromdb.moving-selected-msg') );
		jQuery.ajax({
			url: 'plugin/com.suncode-cuf-components/actions/data-table-from-db-action/processdata/' + uuid,
			method: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				ids: me.collectSelectedIds( selected ),
				variables: me.variables,
				executeAutomapping: me.executeAutomapping,
	    		processId: ActivityInfoService.getProcessId(),
	    		activityId: ActivityInfoService.getActivityId(),
	    		overwrite: me.get("overwrite")
			})
		}).done( function(result) {
		    me.setColumnData(result.data, result.mappedVariablesByDataChoosers);
			me.writeDataToVariables( result.mappedVariablesByDataChoosers );

			if (me.get("saveFormAfterMoving")) {
				FormService.save();
			}

			me.cufWindow.unmask();
			me.cufWindow.close();
		});
	},

	collectSelectedIds: function( selected ) {
		return PW.map( selected, function( row ) {
			return row.get("internalId");
		});
	},

	prepareColumnParameters : function(){
		this.columnIndexes = this.get("columnIndexes");
		this.columnIndexes.push('internalId');
		this.columnParameters = PW.map(this.get("columnNames"), function(columnName, i){
		    return {
		        text: columnName,
		        dataIndex: this.columnIndexes[i],
		        filter: this.getFilter(i),
		        hidden: this.get("isHiddenColumn") ? this.get("isHiddenColumn")[i] : false,
		        flex: 1,
				menuDisabled: !this.get("columnContextMenu")
		    };
		}, this);
	},

	getFilter : function(i) {
		if (!PW.isEmpty(this.get("columnsTypes"))){
			if ( this.get("columnsTypes")[i] === "string"){
				return CUF.DataFilters.like();
			} else if ( this.get("columnsTypes")[i] === "integer"){
				return CUF.DataFilters.betweenInt();
			} else if ( this.get("columnsTypes")[i] === "float"){
				return CUF.DataFilters.betweenDouble();
			} else if ( this.get("columnsTypes")[i] === "date"){
				return CUF.DataFilters.betweenDate();
			}
		}
	},

	writeDataToVariables : function( mappedVariablesByDataChoosers ){
		var me = this;
		var columnsToSet = me.resolveColumnsToSet( mappedVariablesByDataChoosers );
		var columnData = me.columnData;
		var currentValues = me.variableValues( columnsToSet );
		if (devMode){
    		Logger.debug("Action data-table-from-db-action will now set variables...");
    	}

		if (!this.executeAutomapping) {
			me.suspendAutoMappings(columnsToSet);
		}

		try {
			if( this.table && this.get("overwrite") ) {
				this.table.clear();
			}
			PW.each(columnsToSet, function(column, index) {
				if( column ) {
					var newValue = columnData[column.getId()];
					if( column.isStandaloneVariable ) {
						if( newValue.length < 2 ) {
							column.setValue( this.convertValue( newValue[0], column.getType() ) );
						}
						else if (column.getType().is("string")) {
							switch (this.multiVals) {
								case 'UNIQUE' : {
									this.handleUniqueValues(column, newValue);
									break;
								}
								case 'FIRST' : {
									column.setValue(newValue[0]);
									break;
								}
								default : Logger.error("Cannot add multiple values to a non-array variable with multiple value handling unspecified or set to BLOCK!");
									break;
							}
						}
						else {
							Logger.error("Cannot add multiple values to a non-array variable which is also of a different type than string!");
						}
					}
					else {
						var tempValues = [];
						for(var i = 0; i < newValue.length; i++){
							tempValues.push(this.convertValue(newValue[i], column.getType()));
						}
						if ( this.get("overwrite") ) {
							column.setValue( tempValues );
						}
						else {
							column.setValue(currentValues[column.getId()].concat(tempValues));
						}
					}
				}
			}, this);
		}
		finally {
			if (!this.executeAutomapping) {
				me.resumeAutoMappings(columnsToSet);
			}
		}
	},

	variableValues: function( variables ) {
		var values = {};
		PW.each(variables, function(variable){
			if( variable ) {
				values[variable.getId()] = variable.getValue();
			}
		}, this);
		return values;
	},

	convertValue: function( value, type ) {
		if (type.is("float") || type.is("integer") || type.is("float[]") || type.is("integer[]") ) {
			if( value && typeof value === 'string') {
				value = value.replace(/ /g, '').replace(/,/g, '.');
			}
			return Number(value);
		}
		else if (type.is("date") || type.is("datetime") || type.is("date[]") || type.is("datetime[]") ) {
			try {
				return value ? new Date(value) : null;
			}
			catch(e) {
				Logger.error('Could not create Date from value: ' + value);
				return null;
			}
		}
		else if (type.is("boolean") || type.is("boolean[]")) {
			if( !value ) {
				return false;
			}
			else if (typeof value === "boolean"){
				return value;
			}
			else if(typeof value === "string"){
				return (value === 'true');
			}
			else {
				return false;
			}
		}
		else {
			return String(value);
		}
	},

	handleUniqueValues: function(variable, data) {
		var uniqueValues = [];
		for (var i=0; i<data.length; i++) {
			var value = data[i];
			if (jQuery.inArray(value, uniqueValues) === -1) {
				uniqueValues.push(value);
			}
		}
		variable.setValue( uniqueValues.join(";") );
	},

	resolveColumnsToSet: function( mappedVariablesByDataChoosers ) {
	    var columnsToSet = this.get("columnsToSet") || [];
	    PW.each(mappedVariablesByDataChoosers, function(mappedVariableId){
            var variable = this.table.getVariable( mappedVariableId );
            if( variable ) {
                columnsToSet.push( variable );
            }
        }, this);

	    return columnsToSet;
	},

	suspendAutoMappings: function( columnsToSet ) {
        var variablesId = [];
        var variables = columnsToSet.concat( this.table ? this.table.getVariables() : []);
        for( var i=0; i< variables.length; i++) {
        	if( variables[i] ) {
				variablesId.push(variables[i].getId());
			}
        }
        VariableService.suspendAutoMapping( variablesId );
    },

    resumeAutoMappings: function( columnsToSet ) {
        var variablesId = [];
        var variables = columnsToSet.concat( this.table ? this.table.getVariables() : []);
        for( var i=0; i< variables.length; i++) {
			if( variables[i] ) {
				variablesId.push(variables[i].getId());
			}
        }
        VariableService.resumeAutoMapping( variablesId );
    },

	setColumnData : function(data, mappedVariablesByDataChoosers){
		this.resetColumnData( mappedVariablesByDataChoosers );
		for(var i = 0; i < data.length; i++){
			this.addRow(data[i], i, mappedVariablesByDataChoosers);
		}
	},

	resetColumnData : function( mappedVariablesByDataChoosers ){
		this.columnData = {};
		PW.each(this.columnIndexes, function(name, index){
			if( name !== "internalId" ) {
				this.columnData[this.variables[index].id] = [];
			}
        }, this);
		PW.each(mappedVariablesByDataChoosers, function(mappedVariableId){
		    this.columnData[mappedVariableId] = [];
		}, this);
	},

	addRow : function(row, rowNumber, mappedVariablesByDataChoosers){
		PW.each(this.columnIndexes, function(name, index){
		    if( name !== "internalId" ) {
				this.columnData[this.variables[index].id][rowNumber] = row[name];
		    }
        }, this);
		PW.each(mappedVariablesByDataChoosers, function(mappedVariableId){
            this.columnData[mappedVariableId][rowNumber] = row[mappedVariableId];
        }, this);
	}
});