PW.FormActions.create('cuf.common.activity.actions.AcceptActivity', {

    defaultActions: {
        button: async function () {
            let jsonObj = await this.acceptActivity()
                .then(jsonObj => {
                    return jsonObj;
                })
                .catch(error => {
                    MessageService.showFailure(error.message);
                });

            if (jsonObj === undefined) {
                return;
            }

            switch (this.get('actionAfterCreatingTask')) {
                case 'DO_NOTHING':
                    MessageService.showSuccess(CUFCommon.t('cuf.common.activity.actions.AcceptActivity.messages.acceptedCorrectly'));
                    break;
                case 'GO_BACK':
                    window.history.back();
                    break;
                case 'OPEN_ONLY_ONE':
                    if (!openTask(true)) {
                        window.history.back();
                    }
                    break;
                case 'OPEN_ONE_OF_MANY':
                    if (!openTask(false)) {
                        window.history.back();
                    }
                    break;
                default:
                    break;
            }

            function openTask(openTaskIfCurrentUserIsOnlyOneExecutor) {

                for (let item of jsonObj.data) {
                    if (item.assignments && Array.isArray(item.assignments) && (
                        openTaskIfCurrentUserIsOnlyOneExecutor && item.assignments.length === 1 && item.assignments.includes(Suncode.getCurrentUser()) ||
                        !openTaskIfCurrentUserIsOnlyOneExecutor && item.assignments.includes(Suncode.getCurrentUser())
                    )) {
                        window.open("ProcesActivity.do?activityId=" + item.activityId + "&processKey=" + processId, "_self");
                        return true;
                    }
                }
                return false;
            }
        }
    },

    acceptActivity: async function () {
        const variablesToSet = this.getRaw('variablesToSet').value.map(variable => variable.value.id);
        const valuesToSet = this.getRaw('valuesToSet').value.map(
            variable => {
                if (variable.value.isFunctionCall === true) {
                    return variable.value.call();
                }
                if (variable.value.isVariable === true) {
                    return variable.value.getValue();
                }
                return variable.value;
            }
        );
        const variableValueMap = isHistory ? {} : {...FormService.getValues()};
        [...variablesToSet.keys()].forEach(i => variableValueMap[variablesToSet[i]] = valuesToSet[i]);

        return await fetch(this.prepareUrl("ActivityController/acceptActivity"), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                activityId: activityId,
                processId: processId,
                variableValueMap: variableValueMap,
                acceptButtonId: this.get('acceptButtonId'),
                ignoreValidatorsUnderButton: this.get('ignoreValidatorsUnderButton')
            })
        })
            .then(async response => {
                if (!response.ok) {
                    throw new Error(await response.text());
                }
                return response.json();
            })
            .then(jsonObj => {
                if (!(jsonObj && 'total' in jsonObj && Array.isArray(jsonObj.data))) {
                    throw new Error(CUFCommon.t('cuf.common.activity.actions.AcceptActivity.messages.incorrectData'));
                }
                return jsonObj;
            })
            .catch(error => {
                throw new Error(error);
            });
    },

    prepareUrl: function (endpoint) {
        return window.location.origin + PlusWorkflow.getAbsolutePath("/plugin/com.suncode-cuf-components/" + endpoint);
    }
});