/**
 * Return current year.
 */
PW.Functions.register("currentYear", "integer", null, function () {
    return currentYear();
});

function currentYear() {
    return new Date().getFullYear();
}

PW.Functions.register("intersect", "string[]", ["string[]", "string[]"], function (arr1, arr2) {
    return getIntersect(arr1, arr2);
});

PW.Functions.register("intersect", "integer[]", ["integer[]", "integer[]"], function (arr1, arr2) {
    return getIntersect(arr1, arr2);
});

PW.Functions.register("intersect", "float[]", ["float[]", "float[]"], function (arr1, arr2) {
    return getIntersect(arr1, arr2);
});
/*
PW.Functions.register("intersect", "boolean[]", ["boolean[]", "boolean[]"], function(arr1, arr2){
    return getIntersect(arr1, arr2);
});
*/
PW.Functions.register("intersect", "date[]", ["date[]", "date[]"], function (arr1, arr2) {
    return getIntersectDate(arr1, arr2);
});
/*
PW.Functions.register("intersect", "datetime[]", ["datetime[]", "datetime[]"], function(arr1, arr2){
    return getIntersectDate(arr1, arr2);
});
*/
PW.Functions.register("except", "string[]", ["string[]", "string[]"], function (arr1, arr2) {
    return getExcept(arr1, arr2);
});

PW.Functions.register("except", "integer[]", ["integer[]", "integer[]"], function (arr1, arr2) {
    return getExcept(arr1, arr2);
});

PW.Functions.register("except", "float[]", ["float[]", "float[]"], function (arr1, arr2) {
    return getExcept(arr1, arr2);
});
/*
PW.Functions.register("except", "boolean[]", ["boolean[]", "boolean[]"], function(arr1, arr2){
    return getExcept(arr1, arr2);
});
*/
PW.Functions.register("except", "date[]", ["date[]", "date[]"], function (arr1, arr2) {
    return getExceptDate(arr1, arr2);
});
/*
PW.Functions.register("except", "datetime[]", ["datetime[]", "datetime[]"], function(arr1, arr2){
    return getExceptDate(arr1, arr2);
});
*/
PW.Functions.register("union", "string[]", ["string[]", "string[]"], function (arr1, arr2) {
    return getUnion(arr1, arr2);
});

PW.Functions.register("union", "integer[]", ["integer[]", "integer[]"], function (arr1, arr2) {
    return getUnion(arr1, arr2);
});

PW.Functions.register("union", "float[]", ["float[]", "float[]"], function (arr1, arr2) {
    return getUnion(arr1, arr2);
});
/*
PW.Functions.register("union", "boolean[]", ["boolean[]", "boolean[]"], function(arr1, arr2){
    return getUnion(arr1, arr2);
});
*/
PW.Functions.register("union", "date[]", ["date[]", "date[]"], function (arr1, arr2) {
    return getUnionDate(arr1, arr2);
});
/*
PW.Functions.register("union", "datetime[]", ["datetime[]", "datetime[]"], function(arr1, arr2){
    return getUnionDate(arr1, arr2);
});
*/
PW.Functions.register("symmetricDifference", "string[]", ["string[]", "string[]"], function (arr1, arr2) {
    return getSymDifference(arr1, arr2);
});

PW.Functions.register("symmetricDifference", "integer[]", ["integer[]", "integer[]"], function (arr1, arr2) {
    return getSymDifference(arr1, arr2);
});

PW.Functions.register("symmetricDifference", "float[]", ["float[]", "float[]"], function (arr1, arr2) {
    return getSymDifference(arr1, arr2);
});
/*
PW.Functions.register("symmetricDifference", "boolean[]", ["boolean[]", "boolean[]"], function(arr1, arr2){
    return getSymDifference(arr1, arr2);
});
*/
PW.Functions.register("symmetricDifference", "date[]", ["date[]", "date[]"], function (arr1, arr2) {
    return getSymDifferenceDate(arr1, arr2);
});
/*
PW.Functions.register("symmetricDifference", "datetime[]", ["datetime[]", "datetime[]"], function(arr1, arr2){
    return getSymDifferenceDate(arr1, arr2);
});
*/
PW.Functions.register("unionAll", "string[]", ["string[]", "string[]"], function (arr1, arr2) {
    return getUnionAll(arr1, arr2);
});

PW.Functions.register("unionAll", "integer[]", ["integer[]", "integer[]"], function (arr1, arr2) {
    return getUnionAll(arr1, arr2);
});

PW.Functions.register("unionAll", "float[]", ["float[]", "float[]"], function (arr1, arr2) {
    return getUnionAll(arr1, arr2);
});
/*
PW.Functions.register("unionAll", "boolean[]", ["boolean[]", "boolean[]"], function(arr1, arr2){
    return getUnionAll(arr1, arr2);
});
*/
PW.Functions.register("unionAll", "date[]", ["date[]", "date[]"], function (arr1, arr2) {
    return getUnionAll(arr1, arr2);
});
/*
PW.Functions.register("unionAll", "datetime[]", ["datetime[]", "datetime[]"], function(arr1, arr2){
    return getUnionAll(arr1, arr2);
});
*/

PW.Functions.register("distinct", "string[]", ["string[]"], function (array) {
    return getDistinct(array);
});

PW.Functions.register("distinct", "integer[]", ["integer[]"], function (array) {
    return getDistinct(array);
});

PW.Functions.register("distinct", "float[]", ["float[]"], function (array) {
    return getDistinct(array);
});
/*
PW.Functions.register("distinct", "boolean[]", ["boolean[]"], function(array){
    return getDistinct(array);
});
*/
PW.Functions.register("distinct", "date[]", ["date[]"], function (array) {
    return getDistinctDate(array);
});
/*
PW.Functions.register("distinct", "datetime[]", ["datetime[]"], function(array){
    return getDistinctDate(array);
});
*/
PW.Functions.register("replaceDiacritics", "string", ["string"], function (text) {
    return replaceDiacritics(text);
});

PW.Functions.register("replaceMany", "string", ["string", "string", "string[]", "string"], function (orginalString, replaceOptions, replaceFrom, replaceTo) {
    return getReplacedString(orginalString, replaceOptions, replaceFrom, replaceTo);
});

PW.Functions.register("getId", "string", ["variable"], function (variable) {
    return variable.getId();
});

PW.Functions.register("createStringArray", "string[]", ["integer"], function (length) {
    return createArray(length, getDefaultValue("string"));
});

PW.Functions.register("createIntegerArray", "integer[]", ["integer"], function (length) {
    return createArray(length, getDefaultValue("integer"));
});

PW.Functions.register("createFloatArray", "float[]", ["integer"], function (length) {
    return createArray(length, getDefaultValue("float"));
});

PW.Functions.register("createDateArray", "date[]", ["integer"], function (length) {
    return createArray(length, getDefaultValue("date"));
});

PW.Functions.register("createStringArray", "string[]", ["integer", "string"], function (length, initialValue) {
    return createArray(length, initialValue);
});

PW.Functions.register("createIntegerArray", "integer[]", ["integer", "integer"], function (length, initialValue) {
    return createArray(length, initialValue);
});

PW.Functions.register("createFloatArray", "float[]", ["integer", "float"], function (length, initialValue) {
    return createArray(length, initialValue);
});

PW.Functions.register("createDateArray", "date[]", ["integer", "date"], function (length, initialValue) {
    return createArray(length, initialValue);
});

PW.Functions.register("isProcessedTable", "boolean", ["string"], function (tableId) {
    return CUFCommon.isProcessedTable(tableId);
});

PW.Functions.register("isEUCountry", "boolean", ["string"], function (countryCode) {
    return getEuropeanUnionCountryCodes().some(code => code === countryCode.toUpperCase());
});

PW.Functions.register("getNextSequenceValue", "string", ["string", "string"], function (format, sequenceName) {
    return getNextSequenceValue(format, sequenceName);
});

function getIntersect(arr1, arr2) {
    return arr1.filter(function (n) {
        return arr2.indexOf(n) > -1;
    }).unique();
}

function getIntersectDate(arr1, arr2) {
    return arr1.filter(function (n) {
        return arr2.indexOfDate(n) > -1;
    }).uniqueDate();
}

function getExcept(arr1, arr2) {
    return arr1.diff(arr2).unique();
}

function getExceptDate(arr1, arr2) {
    return arr1.diffDate(arr2).uniqueDate();
}

function getUnion(arr1, arr2) {
    return arr1.concat(arr2).unique();
}

function getUnionDate(arr1, arr2) {
    return arr1.concat(arr2).uniqueDate();
}

function getSymDifference(arr1, arr2) {
    var set1 = getExcept(arr1, arr2);
    var set2 = getExcept(arr2, arr1);
    return getUnion(set1, set2);
}

function getSymDifferenceDate(arr1, arr2) {
    var set1 = getExceptDate(arr1, arr2);
    var set2 = getExceptDate(arr2, arr1);
    return getUnionDate(set1, set2);
}

function getUnionAll(arr1, arr2) {
    return arr1.concat(arr2);
}

function getDistinct(array) {
    return array.unique();
}

function getReplacedString(orginalString, replaceOptions, replaceFrom, replaceTo) {
    if (replaceOptions == "WINDOWS") {
        replaceFrom = ["<", ">", ":", "\"", "/", "|", "\\", "?", "*"];
    }
    if (replaceOptions == "LINUX") {
        replaceFrom = ["/"];
    }
    replaceFrom.forEach(function (item) {
        orginalString = orginalString.replaceAll(item, replaceTo);
    });
    return orginalString;
}

function getDistinctDate(array) {
    return array.uniqueDate();
}

function replaceDiacritics(text) {
    var normalized = text.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    var result = normalized.replaceAll("ł", "l")
        .replaceAll("Ł", "L")
        .replaceAll("Đ", "D")
        .replaceAll("đ", "d")
        .replaceAll("Ø", "O")
        .replaceAll("ø", "o");

    return result;
}

function createArray(length, initialValue) {
    if (length < 0) {
        return [];
    }
    return Array(length).fill(initialValue);
}

function getDefaultValue(type) {
    switch (type) {
        case "integer":
        case "float":
            return 0;
        case "date":
            return null;
        case "string":
            return "";
    }
}

function getEuropeanUnionCountryCodes() {
    return ["AT", "BE", "BG", "HR", "CY", "CZ", "DK", "EE", "FI", "FR", "GR", "ES", "IE", "LT", "LU", "LV", "MT", "NL", "DE", "PL", "PT", "RO", "SK",
        "SI", "SE", "HU", "IT"];
}

function getNextSequenceValue(numberFormat, sequenceName) {
    let result = null;

    jQuery.ajax({
        type: "GET",
        url: "plugin/com.suncode-cuf-components/sequence/number/",
        data: {
            numberFormat,
            sequenceName
        },
        cache: false,
        async: false,
        success: function (data) {
            result = data;
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error("Request failed:", errorThrown);
        }
    });

    return result;
}

Array.prototype.unique = function () {
    var a = this.concat();
    for (var i = 0; i < a.length; ++i) {
        for (var j = i + 1; j < a.length; ++j) {
            if (a[i] === a[j])
                a.splice(j--, 1);
        }
    }
    return a;
};

Array.prototype.uniqueDate = function () {
    var a = this.concat();
    for (var i = 0; i < a.length; ++i) {
        for (var j = i + 1; j < a.length; ++j) {
            if (a[i] == null && a[j] == null)
                a.splice(j--, 1);
            else if (a[i] == null || a[j] == null)
                continue;
            else if (a[i].toString() === a[j].toString())
                a.splice(j--, 1);
        }
    }
    return a;
};

Array.prototype.diff = function (a) {
    return this.filter(function (i) {
        return a.indexOf(i) < 0;
    });
};

Array.prototype.diffDate = function (a) {
    return this.filter(function (i) {
        return a.indexOfDate(i) < 0;
    });
};

Array.prototype.indexOfDate = function (date) {
    for (var i = 0; i < this.length; i++) {
        if (+this[i] === +date) return i;
    }
    ;
    return -1;
};