/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils;

import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ValidatorUtils {
    private static void globalMsg(Boolean confirmation, ValidationErrors errors, String alert, Translator translator) {
        if (Boolean.TRUE.equals(confirmation)) {
            errors.addConfirmation(alert, translator.getMessage("validator.title_default"));
        } else {
            errors.add(alert);
        }
    }

    private static void localMsg(ValidationErrors errors, Variable[] var, String[] msg, Translator translator, List<Integer> rowNotValid) {
        Assert.isTrue((var.length == msg.length ? 1 : 0) != 0, (String)"the table of variables and messages are not the same length");
        for (int i = 0; i < var.length; ++i) {
            if (StringUtils.isBlank((CharSequence)msg[i])) continue;
            if (var[i].isArray()) {
                if (rowNotValid.isEmpty()) {
                    errors.add("[" + var[i].getName() + "] " + msg[i]);
                    continue;
                }
                for (Integer rowIndex : rowNotValid) {
                    errors.add(msg[i], var[i].getId(), rowIndex.intValue());
                }
                continue;
            }
            errors.add(msg[i], var[i].getId());
        }
    }

    public static void validationFailed(String msgType, Boolean confirmation, String alert, Translator translator, ValidationErrors errors, Variable[] var, String[] msg, List<Integer> rowNotValid) {
        switch (msgType.toLowerCase()) {
            case "global": {
                ValidatorUtils.globalMsg(confirmation, errors, alert, translator);
                break;
            }
            case "local": {
                ValidatorUtils.localMsg(errors, var, msg, translator, rowNotValid);
                break;
            }
            case "localandglobal": {
                ValidatorUtils.globalMsg(confirmation, errors, alert, translator);
                ValidatorUtils.localMsg(errors, var, msg, translator, rowNotValid);
                break;
            }
            default: {
                ValidatorUtils.globalMsg(confirmation, errors, alert, translator);
            }
        }
    }
}

