/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.utils;

import com.suncode.cuf.common.user.servlets.OrganizationalUnitDto;
import com.suncode.cuf.common.user.servlets.RoleDto;
import com.suncode.cuf.common.user.servlets.UserDto;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class UserUtils {
    public static List<UserDto> usersToDto(List<User> users) {
        return users.stream().map(user -> UserUtils.userToDto(user)).collect(Collectors.toList());
    }

    public static UserDto userToDto(User user) {
        return UserDto.builder().firstName(user.getFirstName()).lastName(user.getLastName()).email(user.getEmail()).fullName(user.getFullName()).userName(user.getUserName()).build();
    }

    public static List<OrganizationalUnitDto> ousToDto(List<OrganizationalUnit> ous) {
        return ous.stream().map(ou -> UserUtils.ouToDto(ou)).collect(Collectors.toList());
    }

    public static OrganizationalUnitDto ouToDto(OrganizationalUnit ou) {
        String displayName = ou.getName();
        return OrganizationalUnitDto.builder().symbol(ou.getSymbol()).name(ou.getName()).displayName(displayName).build();
    }

    public static List<RoleDto> rolesToDto(List<Role> roles) {
        return new ArrayList<RoleDto>(roles.stream().map(role -> UserUtils.roleToDto(role)).collect(Collectors.toSet()));
    }

    private static RoleDto roleToDto(Role role) {
        String specialId;
        String displayName = specialId = role.getProcessDefId() == null ? role.getPackageId() + "::" + role.getRoleId() : role.getPackageId() + ":" + role.getProcessDefId() + ":" + role.getRoleId();
        return RoleDto.builder().packageId(role.getPackageId()).processDefId(role.getProcessDefId()).roleId(role.getRoleId()).displayName(displayName).specialId(specialId).build();
    }
}

