/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.servlets;

import com.suncode.cuf.common.user.UserDataService;
import com.suncode.cuf.common.user.servlets.GroupDto;
import com.suncode.cuf.common.user.servlets.OrganizationalUnitDto;
import com.suncode.cuf.common.user.servlets.RoleDto;
import com.suncode.cuf.common.user.servlets.UserDto;
import com.suncode.cuf.common.user.substitutes.SubstitutedDataGetter;
import com.suncode.cuf.common.user.substitutes.model.SubstitutedUsersData;
import com.suncode.pwfl.search.CountedResult;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UsersController {
    private static final Logger log = LoggerFactory.getLogger(UsersController.class);
    @Autowired
    private UserDataService userService;
    @Autowired
    private SubstitutedDataGetter getter;

    @RequestMapping(value={"get-substitute"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public SubstitutedUsersData getUserData(@RequestParam String userName, @RequestParam(defaultValue="false") Boolean downloadAllLevels) {
        return this.getter.getData(userName, downloadAllLevels);
    }

    @RequestMapping(value={"usernames-to-fullnames"}, method={RequestMethod.GET}, produces={"text/plain; charset=utf-8"})
    @ResponseBody
    public String getFullnames(@RequestParam String sourceValue) throws Exception {
        return this.userService.getFullNames(sourceValue);
    }

    @RequestMapping(value={"user-exists"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public Boolean getUser(@RequestParam String userName, @RequestParam Boolean onlyActive) throws Exception {
        return this.userService.userExists(userName, onlyActive);
    }

    @RequestMapping(value={"has-role"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public Boolean getFormattedSequenceNumber(@RequestParam String userName, @RequestParam String roleId, @RequestParam Boolean searchInPackage, @RequestParam String processId) {
        return this.userService.doesUserHaveRole(userName, roleId, processId, searchInPackage);
    }

    @Transactional
    @RequestMapping(value={"user-data"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getData(@RequestParam String username, @RequestParam(value="dataTypes[]", required=true) String[] dataTypes) throws Exception {
        HashMap<String, Object> userData = new HashMap<String, Object>();
        try {
            for (int i = 0; i < dataTypes.length; ++i) {
                String paramValue = this.userService.getUserData(username, dataTypes[i], false).toString();
                userData.put(dataTypes[i], paramValue);
            }
            return userData;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            return userData;
        }
    }

    @RequestMapping(value={"users"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public CountedResult<UserDto> getUsers(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.userService.getCountedUsers(query, start, limit);
    }

    @RequestMapping(value={"groups"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public CountedResult<GroupDto> getGroups(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.userService.getCountedGroups(query, start, limit);
    }

    @RequestMapping(value={"ous"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public CountedResult<OrganizationalUnitDto> getOus(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.userService.getCountedOus(query, start, limit);
    }

    @RequestMapping(value={"roles"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public CountedResult<RoleDto> getRoles(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.userService.getCountedRoles(query, start, limit);
    }
}

