/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.functions;

import com.suncode.cuf.common.user.UserDataService;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.search.SimpleHibernateUserFilter;
import com.suncode.pwfl.administration.user.search.UserPropertyFilter;
import com.suncode.pwfl.administration.user.search.UserSortProperty;
import com.suncode.pwfl.administration.user.search.UserSorter;
import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionContext;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.hibernate.SimpleHibernateFilter;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Functions
@FunctionsScript(value="/functions/usercontext-functions.js")
public class UserFunctions {
    private static final Logger log = LoggerFactory.getLogger(UserFunctions.class);
    private static final String ROLES_PROCESS_DEFINITION_ID = "roles.processDefId";
    private static final String ROLES_PACKAGE_ID = "roles.packageId";
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    private SubstitutionService substitutionService;
    @Autowired
    private UserDataService userDataService;

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersFromGroup(String groupName) throws GroupNotFoundException {
        List userListFromGroup = this.userFinder.findByGroup(groupName);
        return this.getUsersLogins(userListFromGroup);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersFromGroupAndOU(String groupName, String ou) throws GroupNotFoundException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.GROUP_NAME, (Object)groupName, FilterOperator.EQ));
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ORGANIZATIONALUNIT_SYMBOL, (Object)ou, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRole(String roleId) throws IllegalArgumentException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRole(String roleId, String processDefId) throws IllegalArgumentException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        filters.add(new SimpleHibernateFilter(ROLES_PROCESS_DEFINITION_ID, (Object)processDefId, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRole(String roleId, String packageId, String processDefId) throws IllegalArgumentException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        filters.add(new SimpleHibernateFilter(ROLES_PACKAGE_ID, (Object)packageId, FilterOperator.EQ));
        if (StringUtils.isNotEmpty((CharSequence)processDefId)) {
            filters.add(new SimpleHibernateFilter(ROLES_PROCESS_DEFINITION_ID, (Object)processDefId, FilterOperator.EQ));
        }
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRoleFromPackageId(String roleId, String packageId) throws IllegalArgumentException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        filters.add(new SimpleHibernateFilter(ROLES_PACKAGE_ID, (Object)packageId, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRoleAndOU(String roleId, String ou) throws IllegalArgumentException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ORGANIZATIONALUNIT_SYMBOL, (Object)ou, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRoleAndOU(String roleId, String ou, String processDefId) throws IllegalArgumentException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ORGANIZATIONALUNIT_SYMBOL, (Object)ou, FilterOperator.EQ));
        filters.add(new SimpleHibernateFilter(ROLES_PROCESS_DEFINITION_ID, (Object)processDefId, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithRoleAndOU(String roleId, String ou, String packageId, String processDefId) throws IllegalArgumentException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ROLEID, (Object)roleId, FilterOperator.EQ));
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ORGANIZATIONALUNIT_SYMBOL, (Object)ou, FilterOperator.EQ));
        filters.add(new SimpleHibernateFilter(ROLES_PACKAGE_ID, (Object)packageId, FilterOperator.EQ));
        if (StringUtils.isNotEmpty((CharSequence)processDefId)) {
            filters.add(new SimpleHibernateFilter(ROLES_PROCESS_DEFINITION_ID, (Object)processDefId, FilterOperator.EQ));
        }
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Deprecated
    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersFromOU(String ou) throws IllegalArgumentException {
        return this.usersFromOU(ou, false);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersFromOU(String ouName, Boolean includeSubUnits) throws IllegalArgumentException {
        Object[] ousNames = new String[]{ouName};
        if (includeSubUnits.booleanValue()) {
            try {
                List<OrganizationalUnit> ous = this.userDataService.getSubOUsByName(ouName);
                ousNames = (String[])ArrayUtils.addAll((Object[])ousNames, (Object[])this.getOusNames(ous));
            }
            catch (IllegalArgumentException e) {
                log.debug(e.getMessage());
                return new String[0];
            }
        }
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ORGANIZATIONALUNIT_NAME, (Object)ousNames, FilterOperator.IN));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Deprecated
    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersFromOUSymbol(String ouSymbol) throws IllegalArgumentException {
        return this.usersFromOUSymbol(ouSymbol, false);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersFromOUSymbol(String ouSymbol, Boolean includeSubUnits) throws IllegalArgumentException {
        Object[] ousSymbols = new String[]{ouSymbol};
        if (includeSubUnits.booleanValue()) {
            try {
                List<OrganizationalUnit> ous = this.userDataService.getSubOUsBySymbol(ouSymbol);
                ousSymbols = (String[])ArrayUtils.addAll((Object[])ousSymbols, (Object[])this.getOusSymbols(ous));
            }
            catch (IllegalArgumentException e) {
                log.debug(e.getMessage());
                return new String[0];
            }
        }
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.ORGANIZATIONALUNIT_SYMBOL, (Object)ousSymbols, FilterOperator.IN));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Deprecated
    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithPosition(String position) throws IllegalArgumentException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.POSITION_NAME, (Object)position, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Deprecated
    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithPositionSymbol(String positionSymbol) throws IllegalArgumentException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.POSITION_SYMBOL, (Object)positionSymbol, FilterOperator.EQ));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithPositions(String[] positions) throws IllegalArgumentException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.POSITION_NAME, (Object)positions, FilterOperator.IN));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] usersWithPositionsSymbols(String[] positionsSymbols) throws IllegalArgumentException {
        ArrayList<SimpleHibernateUserFilter> filters = new ArrayList<SimpleHibernateUserFilter>();
        filters.add(new SimpleHibernateUserFilter(UserPropertyFilter.POSITION_SYMBOL, (Object)positionsSymbols, FilterOperator.IN));
        CountedResult users = this.userFinder.findByFilters(filters, new UserSorter(UserSortProperty.USERNAME), 0, 0);
        return this.getUsersLogins(users.getData());
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String userWithPosition(String position) throws IllegalArgumentException {
        String[] userNames = this.usersWithPosition(position);
        return userNames.length == 0 ? "" : userNames[0];
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String getFullName(String userName) {
        User user = this.userFinder.findByUserNameIgnoreCase(userName, true, new String[0]);
        return user == null ? "" : user.getFullName();
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] getFullNames(String[] usersNames) {
        return (String[])Arrays.asList(usersNames).stream().map(login -> this.userFinder.findByUserNameIgnoreCase(login, true, new String[0])).map(user -> user == null ? "" : user.getFullName()).toArray(String[]::new);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] userSupervisors(final String userName) {
        TransactionTemplate tt = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        return (String[])tt.execute((TransactionCallback)new TransactionCallback<String[]>(){

            public String[] doInTransaction(TransactionStatus arg0) {
                return UserFunctions.this.getUserSupervisors(userName);
            }
        });
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String userWithPositionSymbol(String positionSymbol) throws IllegalArgumentException {
        String[] userNames = this.usersWithPositionSymbol(positionSymbol);
        return userNames.length == 0 ? "" : userNames[0];
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    @Deprecated
    public String[] userSubstitutions(String userName) {
        return this.getSubstitutionsForSubstitute(userName);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] getSubstitutionsForSubstitute(String userName) {
        return (String[])this.substitutionService.getSubstitutionsForSubstitute(userName).stream().map(substitution -> substitution.getSubstituted().getUserName()).toArray(String[]::new);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] getSubstitutionsForSubstituted(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            log.warn("Empty userName parameter passed to getSubstitutionsForSubstituted function!");
            return new String[0];
        }
        return (String[])this.substitutionService.getSubstituteUsers(userName).stream().map(User::getUserName).toArray(String[]::new);
    }

    @Function(context=true)
    public String[] orginDelegateActivity() {
        FunctionContext context = FunctionContext.current();
        String userName = UserContext.current().getUser().getUserName();
        List delegatedActivities = context.getActivityDelegations(context.getActivityId(), userName);
        if (delegatedActivities != null) {
            String[] substitutedUsers = (String[])delegatedActivities.stream().map(delegation -> delegation.getUserId()).toArray(String[]::new);
            return substitutedUsers;
        }
        return new String[]{userName};
    }

    private String[] getOusSymbols(List<OrganizationalUnit> ous) {
        String[] ousSymbols = new String[ous.size()];
        for (int i = 0; i < ousSymbols.length; ++i) {
            ousSymbols[i] = ous.get(i).getSymbol();
        }
        return ousSymbols;
    }

    private String[] getOusNames(List<OrganizationalUnit> ous) {
        String[] ousNames = new String[ous.size()];
        for (int i = 0; i < ousNames.length; ++i) {
            ousNames[i] = ous.get(i).getName();
        }
        return ousNames;
    }

    protected String[] getUserSupervisors(String userName) {
        ArrayList<String> superVisors = new ArrayList<String>();
        User user = this.userService.getUser(userName, new String[]{"positions"});
        if (user != null) {
            Set positions = user.getPositions();
            for (Position position : positions) {
                User superVisor;
                Position higherPosition;
                Position posWithHigherPos = (Position)this.positionFinder.get((Serializable)position.getId(), new String[]{"higherPosition"});
                if (posWithHigherPos.getHigherPosition() == null || (higherPosition = (Position)this.positionFinder.get((Serializable)posWithHigherPos.getHigherPosition().getId(), new String[]{"user"})) == null || (superVisor = higherPosition.getUser()) == null) continue;
                superVisors.add(superVisor.getUserName());
            }
        }
        return superVisors.toArray(new String[superVisors.size()]);
    }

    private String[] getUsersLogins(List<User> users) {
        return (String[])users.stream().map(User::getUserName).toArray(String[]::new);
    }

    @Function(accessibility=Function.FunctionAccessibility.SERVER)
    public String[] getUserSuperiorsFromOu(String userLogin, String userPositionOuSymbol) {
        return (String[])TransactionWrapper.get().doInHibernateTransaction(session -> {
            User user = this.userService.getUser(userLogin, new String[]{"positions"});
            if (user == null || user.getPositions() == null) {
                return new String[0];
            }
            return (String[])user.getPositions().stream().filter(position -> position.getOrganizationalUnit().getSymbol().equals(userPositionOuSymbol)).map(position -> position.getHigherPosition() != null && position.getHigherPosition().getUser() != null ? position.getHigherPosition().getUser().getUserName() : "").toArray(String[]::new);
        });
    }
}

