/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.datachoosers;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.user.UserCriteriaCreator;
import com.suncode.cuf.common.user.UserDataService;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import com.suncode.pwfl.workflow.form.datachooser.declaration.MappingDeclaration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class UserChooser {
    private static final Logger log = LoggerFactory.getLogger(UserChooser.class);
    @Autowired
    private UserDataService uds;
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private UserFinder userFinder;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("userchooser")).name("dc.userchooser.name")).description("dc.userchooser.desc")).category(new Category[]{Categories.USER})).documentationLink("confluence/x/cwDh")).icon((Icon)SilkIconPack.USER)).parameter().id("usersFilterType").name("dc.userchooser.users-filtering.name").type((Type)Types.STRING).defaultValue((Object)"all").create()).parameter().id("users").type((Type)Types.STRING_ARRAY).name("dc.userchooser.users.name").optional().create()).parameter().id("groupsFilterType").name("dc.userchooser.groups-filtering.name").type((Type)Types.STRING).defaultValue((Object)"off").create()).parameter().id("groups").type((Type)Types.STRING_ARRAY).name("dc.userchooser.groups.name").optional().create()).parameter().id("ousFilterType").name("dc.userchooser.ous-filtering.name").type((Type)Types.STRING).defaultValue((Object)"off").create()).parameter().id("ous").name("dc.userchooser.ous.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("rolesFilterType").name("dc.userchooser.roles-filtering.name").type((Type)Types.STRING).defaultValue((Object)"off").create()).parameter().id("roles").name("dc.userchooser.roles.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("filterBy").name("default.filterBy").type((Type)Types.STRING).defaultValue((Object)"visible").create()).parameter().id("customFilterFields").name("dc.userchooser.custom-filter-fields.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("sortBy").name("default.sortBy").type((Type)Types.STRING).defaultValue((Object)"userName").create()).parameter().id("sortDirection").name("default.sortDirection").type((Type)Types.STRING).defaultValue((Object)"ASC").create()).mapping().id("userName").name("default.username").create().mapping().id("firstName").name("default.firstname").create().mapping().id("lastName").name("default.lastname").create().mapping().id("fullName").name("default.fullname").create().mapping().id("reverseName").name("default.fullname-reverse").create().mapping().id("email").name("default.email").create().mapping().id("ous").name("default.ous").create().mapping().id("ousSymbols").name("default.ouSymbols").create().mapping().id("groups").name("default.groups").create().mapping().id("positions").name("default.positions").create().mapping().id("positionsSymbols").name("default.positionsSymbols").create().mapping().id("roles").name("default.roles").create().mapping().id("superiors").name("default.superiorsUserNames").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param String usersFilterType, @Param String[] users, @Param String groupsFilterType, @Param String[] groups, @Param String ousFilterType, @Param String[] ous, @Param String rolesFilterType, @Param String[] roles, @Param String filterBy, @Param String[] customFilterFields, @Param String sortBy, @Param String sortDirection) {
        try {
            TransactionWrapper.get().doInHibernateTransaction(session -> {
                UserCriteriaCreator userCriteriaCreator = UserCriteriaCreator.builder().usersFilterType(usersFilterType).users(users).groupsFilterType(groupsFilterType).groups(groups).ousFilterType(ousFilterType).ous(ous).rolesFilterType(rolesFilterType).roles(roles).translatorService(this.translatorService).uds(this.uds).query(queryData.getQuery()).filtres(queryData.getFilters()).isCutomFilter(this.isCustomFilter(filterBy)).mappings(dcContext.getMappings()).customFilterFields(customFilterFields).build();
                Pagination pagination = queryData.getPagination();
                pagination.setSorter(new Sorter(sortBy, sortDirection.equals("ASC") ? SortDirection.ASC : SortDirection.DESC));
                CountedResult<User> usersResult = this.findUserCountedResult(userCriteriaCreator, pagination);
                List<Map<String, Object>> usersData = this.getUsersDataForDcResult(usersResult.getData(), dcContext.getMappings());
                result.setTotal(usersResult.getTotal());
                result.setData(usersData);
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private CountedResult<User> findUserCountedResult(UserCriteriaCreator userCriteriaCreator, Pagination pagination) {
        CountedResult usersResult = this.userFinder.getCountedResult(userCriteriaCreator.getUserCriteria(), pagination);
        int total = this.userFinder.findByCriteria(userCriteriaCreator.getUserCriteria(), null, null, true).size();
        usersResult.setTotal((long)total);
        return usersResult;
    }

    private Boolean isCustomFilter(String filterBy) {
        switch (filterBy) {
            case "visible": {
                return false;
            }
            case "custom": {
                return true;
            }
        }
        throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "unknown-dc-filter-type"));
    }

    private List<Map<String, Object>> getUsersDataForDcResult(List<User> users, List<MappingDeclaration> mappings) {
        ArrayList<Map<String, Object>> usersData = new ArrayList<Map<String, Object>>();
        users.stream().forEach(user -> {
            HashSet<String> uniqueOus;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userName", user.getUserName());
            map.put("firstName", user.getFirstName());
            map.put("lastName", user.getLastName());
            map.put("fullName", user.getFullName());
            map.put("reverseName", user.getLastName() + " " + user.getFirstName());
            map.put("email", user.getEmail());
            if (this.doMappingsContains("ous", mappings)) {
                if (this.doMappingsContains("positions", mappings) || this.doMappingsContains("positionsSymbols", mappings)) {
                    map.put("ous", String.join((CharSequence)";", this.uds.getUserOu((User)user)));
                } else {
                    uniqueOus = new HashSet<String>(this.uds.getUserOu((User)user));
                    map.put("ous", String.join((CharSequence)";", uniqueOus));
                }
            }
            if (this.doMappingsContains("ousSymbols", mappings)) {
                if (this.doMappingsContains("positions", mappings) || this.doMappingsContains("positionsSymbols", mappings)) {
                    map.put("ousSymbols", String.join((CharSequence)";", this.uds.getUserOuSymbols((User)user)));
                } else {
                    uniqueOus = new HashSet<String>(this.uds.getUserOuSymbols((User)user));
                    map.put("ousSymbols", String.join((CharSequence)";", uniqueOus));
                }
            }
            if (this.doMappingsContains("groups", mappings)) {
                map.put("groups", String.join((CharSequence)";", this.uds.getUserGroups((User)user)));
            }
            if (this.doMappingsContains("positions", mappings)) {
                map.put("positions", String.join((CharSequence)";", this.uds.getUserPositions((User)user)));
            }
            if (this.doMappingsContains("positionsSymbols", mappings)) {
                map.put("positionsSymbols", String.join((CharSequence)";", this.uds.getUserPositionsSymbols((User)user)));
            }
            if (this.doMappingsContains("roles", mappings)) {
                map.put("roles", String.join((CharSequence)";", this.uds.getUserRoles((User)user)));
            }
            if (this.doMappingsContains("superiors", mappings)) {
                map.put("superiors", String.join((CharSequence)";", this.uds.getUserSuperiors((User)user)));
            }
            usersData.add(map);
        });
        return usersData;
    }

    private boolean doMappingsContains(String string, List<MappingDeclaration> mappings) {
        return mappings.stream().filter(mapping -> string.equals(mapping.getId())).count() > 0L;
    }
}

