/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.user.UserDataService;
import com.suncode.cuf.common.utils.handlers.ApplicationCommentHandler;
import com.suncode.cuf.common.utils.handlers.ErrorHandlersExecution;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Application
public class UsernamesToFullnamesApp {
    private static final Logger log = LoggerFactory.getLogger(UsernamesToFullnamesApp.class);
    @Autowired
    private UserDataService userService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("usernames-to-fullnames")).name("application.user.usernames-to-fullnames.name")).description("application.user.usernames-to-fullnames.desc")).category(new Category[]{Categories.USER})).documentationLink("confluence/x/YoPK")).icon((Icon)SilkIconPack.USER_SUIT)).parameter().id("sourceVar").name("application.user.usernames-to-fullnames.source_param.name").description("application.user.usernames-to-fullnames.source_param.desc").type((Type)Types.VARIABLE).create()).parameter().id("targetVar").name("application.user.usernames-to-fullnames.target_param.name").description("application.user.usernames-to-fullnames.target_param.desc").type((Type)Types.VARIABLE).create()).parameter().id("commentError").name("application.database.defaults.comment_error.name").description("application.database.defaults.comment_error.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap activityContext, final @Param Variable sourceVar, final @Param Variable targetVar, @Param Boolean commentError, Translator translator) throws Exception {
        if (sourceVar.isArray()) {
            TransactionTemplate template = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                    String[] sourceArray = (String[])sourceVar.getValue();
                    String[] arr = (String[])Arrays.stream(sourceArray).map(value -> {
                        try {
                            return UsernamesToFullnamesApp.this.userService.getFullNames((String)value);
                        }
                        catch (Exception e) {
                            log.error("Cannot execute setter.", (Throwable)e);
                            return null;
                        }
                    }).toArray(String[]::new);
                    targetVar.setValue((Object)arr);
                }
            });
        } else {
            try {
                String sourceValue = (String)sourceVar.getValue();
                targetVar.setValue((Object)this.userService.getFullNames(sourceValue));
            }
            catch (Exception e) {
                if (!commentError.booleanValue()) {
                    throw e;
                }
                ApplicationCommentHandler handler = new ApplicationCommentHandler(this.commentService, context.getProcessId(), context.getActivityId(), e);
                ErrorHandlersExecution handlerExecution = new ErrorHandlersExecution(e, handler);
                handlerExecution.handle();
            }
        }
    }
}

