/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user;

import com.suncode.cuf.common.user.servlets.GroupDto;
import com.suncode.cuf.common.user.servlets.OrganizationalUnitDto;
import com.suncode.cuf.common.user.servlets.RoleDto;
import com.suncode.cuf.common.user.servlets.UserDto;
import com.suncode.cuf.common.user.utils.UserUtils;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitNotFoundException;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class UserDataService {
    private static final Logger log = LoggerFactory.getLogger(UserDataService.class);
    @Autowired
    private UserService userService;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleFinder roleFinder;
    @Autowired
    private ProcessService processService;
    @Autowired
    private UserGroupFinder userGroupFinder;
    @Autowired
    private OrganizationalUnitFinder ouFinder;
    @Autowired
    private TranslatorService translatorService;

    public boolean userExists(String username, boolean onlyActive) {
        return this.userFinder.findByUserName(username, onlyActive, new String[0]) != null;
    }

    private String convertUsernameToFullname(String username) throws UserNotFoundException {
        User user = this.userFinder.findByUserName(username, new String[0]);
        if (user == null) {
            throw new UserNotFoundException("U\u017cytkownik nie istnieje w systemie: " + username);
        }
        return user.getFullName();
    }

    private String[] convertUsernamesToFullnames(String[] usernames) throws UserNotFoundException {
        String[] fullNames = new String[usernames.length];
        for (int i = 0; i < usernames.length; ++i) {
            fullNames[i] = this.convertUsernameToFullname(usernames[i]);
        }
        return fullNames;
    }

    public String getFullNames(String userNames) throws UserNotFoundException {
        String[] usernames = userNames.split(";");
        Object[] fullNames = this.convertUsernamesToFullnames(usernames);
        return StringUtils.arrayToDelimitedString((Object[])fullNames, (String)";");
    }

    public boolean doesUserHaveRole(String userName, String roleId, String processId, Boolean searchInPackage) {
        Process process = this.processService.getProcess(processId, new String[]{"processDefinition"});
        ProcessDefinition processDef = process.getProcessDefinition();
        String packageId = processDef.getPackageId();
        if (searchInPackage.booleanValue()) {
            return this.hasRoleWithinPackage(userName, packageId, roleId);
        }
        Role role = this.roleService.getRole(packageId, processDef.getProcessDefinitionId(), roleId);
        if (role != null) {
            return this.roleService.doesUserHasRole(userName, role.getId());
        }
        return false;
    }

    private boolean hasRoleWithinPackage(String userName, String packageId, String roleId) {
        List userRoles = this.roleFinder.findByUserName(userName);
        for (Role role : userRoles) {
            if (!role.getPackageId().equals(packageId) || !role.getRoleId().equalsIgnoreCase(roleId)) continue;
            return true;
        }
        return false;
    }

    public Object getUserData(String login, String userData, boolean isArray) throws IllegalArgumentException {
        User user = this.getUser(login);
        if (user == null) {
            throw new IllegalArgumentException("No user with given login found");
        }
        UserDataType userDataType = UserDataType.valueOf(userData.toUpperCase());
        Set userGroups = user.getGroups();
        Set positions = user.getPositions();
        switch (userDataType) {
            case FIRSTNAME: {
                this.arrayCheck(isArray);
                return user.getFirstName();
            }
            case LASTNAME: {
                this.arrayCheck(isArray);
                return user.getLastName();
            }
            case EMAIL: {
                this.arrayCheck(isArray);
                return user.getEmail();
            }
            case FULLNAME: {
                this.arrayCheck(isArray);
                return user.getFullName();
            }
            case NUMBER: {
                this.arrayCheck(isArray);
                return user.getNumber();
            }
            case GROUPSNAMES: {
                ArrayList<String> groupsNames = new ArrayList<String>();
                for (UserGroup userGroup : userGroups) {
                    groupsNames.add(userGroup.getName());
                }
                return this.getArrayData(isArray, groupsNames);
            }
            case POSITIONSNAMES: {
                ArrayList<String> positionsNames = new ArrayList<String>();
                for (Position position : positions) {
                    positionsNames.add(position.getName());
                }
                return this.getArrayData(isArray, positionsNames);
            }
            case OUNAMES: {
                HashSet<String> ouNamesSet = new HashSet<String>();
                for (Position position : positions) {
                    OrganizationalUnit ou = position.getOrganizationalUnit();
                    if (ou == null) continue;
                    ouNamesSet.add(ou.getName());
                }
                return this.getArrayData(isArray, ouNamesSet);
            }
            case POSITIONSOUSYMBOLS: 
            case OUSYMBOLS: {
                HashSet<String> ouSymbolsSet = new HashSet<String>();
                for (Position position : positions) {
                    OrganizationalUnit ou = position.getOrganizationalUnit();
                    if (ou == null) continue;
                    ouSymbolsSet.add(ou.getSymbol());
                }
                return this.getArrayData(isArray, ouSymbolsSet);
            }
            case POSITIONSSYMBOLS: {
                ArrayList<String> positionsSymbols = new ArrayList<String>();
                for (Position position : positions) {
                    positionsSymbols.add(position.getSymbol());
                }
                return this.getArrayData(isArray, positionsSymbols);
            }
            case SUPERIORSNAMES: {
                ArrayList<String> superVisors = new ArrayList<String>();
                for (Position position : positions) {
                    User superVisor;
                    Position higherPosition;
                    Position posWithHigherPos = (Position)this.positionFinder.get((Serializable)position.getId(), new String[]{"higherPosition"});
                    if (posWithHigherPos.getHigherPosition() == null || (higherPosition = (Position)this.positionFinder.get((Serializable)posWithHigherPos.getHigherPosition().getId(), new String[]{"user"})) == null || (superVisor = higherPosition.getUser()) == null) continue;
                    superVisors.add(superVisor.getUserName());
                }
                return this.getArrayData(isArray, superVisors);
            }
        }
        throw new IllegalArgumentException("Invalid application parameter 'data'");
    }

    public User getUser(String login) throws IllegalArgumentException {
        if (login == null || login.equals("")) {
            throw new IllegalArgumentException("Login is empty!");
        }
        return this.userService.getUser(login, new String[]{"positions", "positions.organizationalUnit", "groups"});
    }

    private Object getArrayData(boolean isArray, Collection<String> values) {
        if (isArray) {
            return values.toArray(new String[values.size()]);
        }
        return StringUtils.collectionToDelimitedString(values, (String)";");
    }

    private void arrayCheck(boolean isArray) {
        if (isArray) {
            throw new IllegalArgumentException("Invalid application parameter 'variablesToSave' type");
        }
    }

    @Transactional
    public List<Map<String, Object>> getUserDCData(String userLogin, String dataType) throws IllegalArgumentException {
        User user = this.getUser(userLogin);
        if (user == null) {
            throw new IllegalArgumentException("No user with given login found");
        }
        Set userGroups = user.getGroups();
        Set positions = user.getPositions();
        UserDataType userDataType = UserDataType.valueOf(dataType.toUpperCase());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        switch (userDataType) {
            case GROUPS: {
                for (UserGroup group : userGroups) {
                    HashMap<String, String> userMap = new HashMap<String, String>();
                    userMap.put("firstname", user.getFirstName());
                    userMap.put("lastname", user.getLastName());
                    userMap.put("email", user.getEmail());
                    userMap.put("fullname", user.getFullName());
                    userMap.put("number", user.getNumber());
                    userMap.put("groupname", group.getName());
                    result.add(userMap);
                }
                break;
            }
            case POSITIONS: {
                for (Position position : positions) {
                    HashMap<String, String> userMap = new HashMap<String, String>();
                    userMap.put("firstname", user.getFirstName());
                    userMap.put("lastname", user.getLastName());
                    userMap.put("email", user.getEmail());
                    userMap.put("fullname", user.getFullName());
                    userMap.put("number", user.getNumber());
                    userMap.put("positionname", position.getName());
                    OrganizationalUnit ou = position.getOrganizationalUnit();
                    if (ou != null) {
                        userMap.put("positionousymbol", ou.getSymbol());
                    }
                    userMap.put("positionsymbol", position.getSymbol());
                    Position actualPosition = (Position)this.positionFinder.get((Serializable)position.getId(), new String[]{"higherPosition"});
                    if (actualPosition.getHigherPosition() == null) {
                        userMap.put("superiorUsername", "");
                        userMap.put("superiorFullname", "");
                        result.add(userMap);
                        continue;
                    }
                    Long higherPositionId = actualPosition.getHigherPosition().getId();
                    Position higherPosition = (Position)this.positionFinder.get((Serializable)higherPositionId, new String[]{"user"});
                    if (higherPosition.getUser() != null) {
                        userMap.put("superiorUsername", higherPosition.getUser().getUserName());
                        userMap.put("superiorFullname", higherPosition.getUser().getFullName());
                    } else {
                        userMap.put("superiorUsername", "");
                        userMap.put("superiorFullname", "");
                    }
                    result.add(userMap);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid application parameter 'dataType'");
            }
        }
        return result;
    }

    public CountedResult<UserDto> getCountedUsers(String userName, Integer start, Integer limit) {
        DetachedCriteria userDc = DetachedCriteria.forClass(User.class, (String)"user");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userName)) {
            Disjunction orGroup = Restrictions.disjunction();
            orGroup.add(Restrictions.ilike((String)"userName", (Object)("%" + userName + "%")));
            orGroup.add(Restrictions.sqlRestriction((String)"CONCAT(LOWER(firstName), ' ', LOWER(lastName)) like LOWER(?)", (Object)("%" + userName + "%"), (Type)StringType.INSTANCE));
            userDc.add((Criterion)orGroup);
        }
        Pagination pagination = Pagination.create((Sorter)new Sorter("userName"), (Integer)start, (Integer)limit);
        CountedResult users = this.userFinder.getCountedResult(userDc, pagination);
        return new CountedResult(users.getTotal(), UserUtils.usersToDto(users.getData()));
    }

    public CountedResult<GroupDto> getCountedGroups(String groupName, Integer start, Integer limit) {
        DetachedCriteria groupsDc = DetachedCriteria.forClass(UserGroup.class, (String)"userGroup");
        if (!StringUtils.isEmpty((Object)groupName)) {
            groupsDc.add(Restrictions.ilike((String)"name", (Object)("%" + groupName + "%")));
        }
        Pagination pagination = Pagination.create((Sorter)new Sorter("name"), (Integer)start, (Integer)limit);
        CountedResult groups = this.userGroupFinder.getCountedResult(groupsDc, pagination);
        return new CountedResult(groups.getTotal(), this.groupsToDto(groups.getData()));
    }

    public CountedResult<OrganizationalUnitDto> getCountedOus(String ouSymbol, Integer start, Integer limit) {
        DetachedCriteria ousDc = DetachedCriteria.forClass(OrganizationalUnit.class, (String)"ou");
        if (!StringUtils.isEmpty((Object)ouSymbol)) {
            ousDc.add(Restrictions.ilike((String)"symbol", (Object)("%" + ouSymbol + "%")));
        }
        Pagination pagination = Pagination.create((Sorter)new Sorter("symbol"), (Integer)start, (Integer)limit);
        CountedResult ous = this.ouFinder.getCountedResult(ousDc, pagination);
        return new CountedResult(ous.getTotal(), UserUtils.ousToDto(ous.getData()));
    }

    public CountedResult<RoleDto> getCountedRoles(String roleSpecialId, Integer start, Integer limit) {
        DetachedCriteria rolesDc = DetachedCriteria.forClass(Role.class, (String)"role");
        if (!StringUtils.isEmpty((Object)roleSpecialId)) {
            if (roleSpecialId.contains(":")) {
                String[] splittedSpecialId = roleSpecialId.split(":");
                if (splittedSpecialId.length != 3) {
                    throw new IllegalArgumentException(this.translatorService.translate("errors.", "specialRoleId") + roleSpecialId);
                }
                rolesDc.add((Criterion)Restrictions.eq((String)"packageId", (Object)splittedSpecialId[0]));
                if (splittedSpecialId[1].equals("")) {
                    rolesDc.add(Restrictions.isNull((String)"processDefId"));
                } else {
                    rolesDc.add((Criterion)Restrictions.eq((String)"processDefId", (Object)splittedSpecialId[1]));
                }
                rolesDc.add((Criterion)Restrictions.eq((String)"roleId", (Object)splittedSpecialId[2]));
            } else {
                Disjunction orGroup = Restrictions.disjunction();
                orGroup.add(Restrictions.ilike((String)"packageId", (Object)("%" + roleSpecialId + "%")));
                orGroup.add(Restrictions.isNull((String)"processDefId"));
                orGroup.add(Restrictions.ilike((String)"processDefId", (Object)("%" + roleSpecialId + "%")));
                orGroup.add(Restrictions.ilike((String)"roleId", (Object)("%" + roleSpecialId + "%")));
                rolesDc.add((Criterion)orGroup);
            }
        }
        Pagination pagination = Pagination.create((Sorter)new Sorter("roleId"), (Integer)start, (Integer)limit);
        CountedResult roles = this.roleFinder.getCountedResult(rolesDc, pagination);
        return new CountedResult(roles.getTotal(), UserUtils.rolesToDto(roles.getData()));
    }

    private List<GroupDto> groupsToDto(List<UserGroup> userGroups) {
        return userGroups.stream().map(group -> this.groupToDto((UserGroup)group)).collect(Collectors.toList());
    }

    private GroupDto groupToDto(UserGroup userGroup) {
        String translatedName;
        String displayName = translatedName = this.translatorService.translateFromSystem(userGroup.getName());
        return GroupDto.builder().name(userGroup.getName()).displayName(displayName).build();
    }

    public List<String> getUserOu(User user) {
        ArrayList<String> ouNames = new ArrayList<String>();
        if (user.getPositions() != null) {
            user.getPositions().stream().forEach(position -> {
                if (position.getOrganizationalUnit() != null) {
                    ouNames.add(position.getOrganizationalUnit().getName());
                }
            });
        }
        return ouNames;
    }

    public List<String> getUserOuSymbols(User user) {
        ArrayList<String> ouSymbols = new ArrayList<String>();
        if (user.getPositions() != null) {
            user.getPositions().stream().forEach(position -> {
                if (position.getOrganizationalUnit() != null) {
                    ouSymbols.add(position.getOrganizationalUnit().getSymbol());
                }
            });
        }
        return ouSymbols;
    }

    public List<String> getUserGroups(User user) {
        ArrayList<String> groups = new ArrayList<String>();
        if (user.getGroups() != null) {
            user.getGroups().stream().forEach(group -> groups.add(group.getName()));
        }
        return groups;
    }

    public List<String> getUserPositions(User user) {
        ArrayList<String> positions = new ArrayList<String>();
        if (user.getPositions() != null) {
            user.getPositions().stream().forEach(position -> positions.add(position.getName()));
        }
        return positions;
    }

    public List<String> getUserPositionsSymbols(User user) {
        ArrayList<String> positionsSymbols = new ArrayList<String>();
        if (user.getPositions() != null) {
            user.getPositions().stream().forEach(position -> positionsSymbols.add(position.getSymbol()));
        }
        return positionsSymbols;
    }

    public List<String> getUserRoles(User user) {
        ArrayList<String> roles = new ArrayList<String>();
        if (user.getPositions() != null) {
            user.getPositions().stream().forEach(position -> {
                if (position.getRoles() != null) {
                    position.getRoles().stream().forEach(role -> {
                        log.debug(role.getRoleId());
                        log.debug(role.getProcessDefId());
                        log.debug(role.getPackageId());
                        roles.add(role.getRoleName());
                    });
                }
            });
        }
        return roles;
    }

    public List<String> getUserSuperiors(User user) {
        ArrayList<String> superiors = new ArrayList<String>();
        if (user.getPositions() != null) {
            user.getPositions().stream().forEach(position -> {
                if (position.getHigherPosition() != null && position.getHigherPosition().getUser() != null) {
                    superiors.add(position.getHigherPosition().getUser().getUserName());
                }
            });
        }
        return superiors;
    }

    public List<RoleFilter> decodeRoleFilters(String[] roles) {
        ArrayList<RoleFilter> roleFilters = new ArrayList<RoleFilter>();
        for (String role : roles) {
            RoleFilter roleFilter = new RoleFilter();
            if (StringUtils.isEmpty((Object)role)) {
                throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "role-is-null"));
            }
            String[] roleSplitted = role.split(":");
            if (roleSplitted.length != 3) {
                throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "role-is-incorrect"));
            }
            roleFilter.setPackageId(roleSplitted[0]);
            roleFilter.setProcessDefId(roleSplitted[1]);
            roleFilter.setRoleIds(Arrays.asList(roleSplitted[2]));
            roleFilters.add(roleFilter);
        }
        return roleFilters;
    }

    public List<OrganizationalUnit> getSubOUsByName(String ou) throws IllegalArgumentException {
        List ous = this.ouFinder.findByName(ou, new String[0]);
        if (ous.isEmpty()) {
            throw new IllegalArgumentException("Organizational unit with name " + ou + " has not been found.");
        }
        if (ous.size() != 1) {
            throw new IllegalArgumentException("More than one organizational units with name " + ou + " has been found.");
        }
        try {
            return this.ouFinder.getSubOrganizationalUnits(((OrganizationalUnit)ous.get(0)).getId());
        }
        catch (OrganizationalUnitNotFoundException e) {
            throw new IllegalArgumentException("Organizational unit with id " + ((OrganizationalUnit)ous.get(0)).getId() + " has not been found.");
        }
    }

    public List<OrganizationalUnit> getSubOUsBySymbol(String ouSymbol) {
        OrganizationalUnit ou = this.ouFinder.findBySymbol(ouSymbol, new String[0]);
        if (ou == null) {
            throw new IllegalArgumentException("Organizational unit with symbol " + ouSymbol + " has not been found.");
        }
        try {
            return this.ouFinder.getSubOrganizationalUnits(ou.getId());
        }
        catch (OrganizationalUnitNotFoundException e) {
            throw new IllegalArgumentException("Organizational unit with id " + ou.getId() + " has not been found.");
        }
    }

    public static enum UserDataType {
        FIRSTNAME,
        LASTNAME,
        EMAIL,
        FULLNAME,
        NUMBER,
        GROUPSNAMES,
        POSITIONSNAMES,
        POSITIONSSYMBOLS,
        POSITIONSOUSYMBOLS,
        OUSYMBOLS,
        OUNAMES,
        POSITIONS,
        GROUPS,
        SUPERIORSNAMES;

    }
}

