/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.storagedata.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class StorageDataUtils {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    public static String[] convertLocalDateArrayToStringArray(LocalDate[] dates) {
        if (dates.length == 1 && dates[0] == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(dates).map(date -> date == null ? null : date.toString()).toArray(String[]::new);
    }

    public static String[] convertLocalDateTimeArrayToStringArray(LocalDateTime[] dates) {
        if (dates.length == 1 && dates[0] == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(dates).map(date -> date == null ? null : date.toString(DATE_TIME_FORMATTER)).toArray(String[]::new);
    }

    public static boolean isParameterIntegerValue(Object paramValue) {
        return paramValue instanceof Integer;
    }

    public static boolean isParameterDoubleValue(Object paramValue) {
        return paramValue instanceof Double;
    }

    public static boolean isParameterBooleanValue(Object paramValue) {
        return paramValue instanceof Boolean;
    }

    public static boolean isParameterDateValue(String paramValue) {
        try {
            LocalDate.parse((String)paramValue);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isParameterDateTimeValue(String paramValue) {
        try {
            LocalDateTime.parse((String)paramValue, (DateTimeFormatter)DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isParameterIntegerArrayValue(Object paramValues) {
        if (!(paramValues instanceof List)) {
            return false;
        }
        for (Object object : (List)paramValues) {
            if (object instanceof Integer || object == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isParameterDoubleArrayValue(Object paramValues) {
        if (!(paramValues instanceof List)) {
            return false;
        }
        for (Object object : (List)paramValues) {
            if (object instanceof Double || object == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isParameterBooleanArrayValue(Object paramValues) {
        if (!(paramValues instanceof List)) {
            return false;
        }
        for (Object object : (List)paramValues) {
            if (object instanceof Boolean || object == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isParameterDateArrayValue(Object paramValue) {
        if (!(paramValue instanceof List)) {
            return false;
        }
        ArrayList dateTableValue = (ArrayList)paramValue;
        return dateTableValue.stream().allMatch(date -> StorageDataUtils.isParameterDateValue(date) || date == null);
    }

    public static LocalDate[] convertStringArrayToLocalDateArray(String[] paramValues) {
        return (LocalDate[])Arrays.stream(paramValues).map(date -> date == null ? null : LocalDate.parse((String)date)).toArray(LocalDate[]::new);
    }

    public static LocalDateTime[] convertStringArrayToLocalDateTimeArray(String[] paramValues) {
        return (LocalDateTime[])Arrays.stream(paramValues).map(date -> date == null ? null : LocalDateTime.parse((String)date, (DateTimeFormatter)DATE_TIME_FORMATTER)).toArray(LocalDateTime[]::new);
    }

    public static boolean isParameterDateTimeTableValue(Object paramValue) {
        if (!(paramValue instanceof List)) {
            return false;
        }
        ArrayList dateTimeArray = (ArrayList)paramValue;
        return dateTimeArray.stream().allMatch(date -> StorageDataUtils.isParameterDateTimeValue(date) || date == null);
    }
}

