/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.servlets;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.cuf.common.user.servlets.RoleDto;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.search.CountedResult;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"roles"})
public class RoleController {
    @Autowired
    private RoleFinder roleFinder;

    @RequestMapping(value={"process/{processDefId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<RoleDto> getRoleByProcess(@PathVariable String processDefId, @RequestParam String query) {
        List roles = this.roleFinder.findByProcess(processDefId);
        List roleToRoleDtoConverter = roles.stream().map(this::convertToDto).collect(Collectors.toList());
        CountedResult countedResult = new CountedResult();
        countedResult.setData(roleToRoleDtoConverter);
        countedResult.setTotal((long)roleToRoleDtoConverter.size());
        return countedResult;
    }

    private RoleDto convertToDto(Role role) {
        return RoleDto.builder().roleId(role.getRoleId()).displayName(new I18Nxpdl().getString(role.getRoleName())).build();
    }
}

