/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.servlets;

import com.suncode.cuf.common.general.enums.JsonDataType;
import com.suncode.cuf.common.general.schemas.JsonDataTypeDto;
import com.suncode.cuf.common.general.schemas.JsonPathPayload;
import com.suncode.cuf.common.general.service.JsonService;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/json"})
public class JsonController {
    @Autowired
    private JsonService jsonService;

    @RequestMapping(value={"datatypes"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<JsonDataTypeDto> getJsonDataTypes(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult countedResult = new CountedResult();
        JsonDataType[] jsonDataTypes = JsonDataType.values();
        List resultList = Arrays.stream(jsonDataTypes).map(e -> e.build()).filter(e -> this.nameOrDisplayNameMatch(query, (JsonDataTypeDto)e)).collect(Collectors.toList());
        int total = resultList.size();
        int startValue = Long.valueOf(start).intValue();
        int limitValue = Long.valueOf(limit).intValue();
        if (total > limitValue) {
            countedResult.setData(resultList.subList(startValue, Math.min(startValue + limitValue - 1, resultList.size())));
        } else {
            countedResult.setData(resultList);
        }
        countedResult.setTotal((long)total);
        return countedResult;
    }

    @RequestMapping(value={"jsonPath"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public String[] getJsonPath(@RequestBody JsonPathPayload jsonPathPayload) {
        if (StringUtils.isBlank((CharSequence)jsonPathPayload.getChildNodeName())) {
            return this.jsonService.readJsonPath(jsonPathPayload.getJsonText(), jsonPathPayload.getJsonPath());
        }
        return this.jsonService.readJsonPath(jsonPathPayload.getJsonText(), jsonPathPayload.getJsonPath(), jsonPathPayload.getChildNodeName());
    }

    private boolean nameOrDisplayNameMatch(String query, JsonDataTypeDto jsonDateTypeDto) {
        return StringUtils.isBlank((CharSequence)query) || jsonDateTypeDto.getName().toLowerCase().contains(query.toLowerCase()) || jsonDateTypeDto.getDisplayName().toLowerCase().contains(query.toLowerCase());
    }
}

