/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.suncode.cuf.common.general.service.JsonService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class JsonServiceImpl
implements JsonService {
    private static final String EMPTY_STRING = "";

    @Override
    public String[] readJsonPath(String text, String path) {
        Configuration configuration = this.createConfigurationCriteria();
        ArrayNode nodes = (ArrayNode)JsonPath.using((Configuration)configuration).parse(text).read(path, new Predicate[0]);
        ArrayList<String> jsonValues = new ArrayList<String>();
        this.fillJsonValuesList(jsonValues, nodes);
        return jsonValues.toArray(new String[0]);
    }

    @Override
    public String[] readJsonPath(String text, String path, String childNodeName) {
        Configuration configuration = this.createConfigurationCriteria();
        ArrayNode nodes = (ArrayNode)JsonPath.using((Configuration)configuration).parse(text).read(path, new Predicate[0]);
        LinkedList<String> jsonValues = new LinkedList<String>();
        if (StringUtils.isNotBlank((CharSequence)childNodeName)) {
            for (JsonNode node : nodes) {
                if (node.get(childNodeName) == null) {
                    jsonValues.add(EMPTY_STRING);
                    continue;
                }
                if (node.get(childNodeName).isObject() || node.get(childNodeName).isArray()) {
                    jsonValues.add(EMPTY_STRING);
                    continue;
                }
                jsonValues.add(node.get(childNodeName).textValue());
            }
        } else {
            this.fillJsonValuesList(jsonValues, nodes);
        }
        return jsonValues.toArray(new String[0]);
    }

    private Configuration createConfigurationCriteria() {
        return Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS}).build();
    }

    private void fillJsonValuesList(List<String> jsonValues, ArrayNode nodes) {
        for (JsonNode node : nodes) {
            if (node.isObject() || node.isArray()) {
                jsonValues.add(EMPTY_STRING);
                continue;
            }
            jsonValues.add(node.textValue());
        }
    }
}

