/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.validators;

import com.suncode.cuf.archive.verification.ConditionType;
import com.suncode.cuf.archive.verification.DocumentVerifier;
import com.suncode.cuf.archive.verification.VerificationMode;
import com.suncode.cuf.archive.verification.internal.condition.EQCondition;
import com.suncode.cuf.archive.verification.internal.condition.GECondition;
import com.suncode.cuf.archive.verification.internal.condition.GTCondition;
import com.suncode.cuf.archive.verification.internal.condition.LECondition;
import com.suncode.cuf.archive.verification.internal.condition.LTCondition;
import com.suncode.cuf.archive.verification.internal.condition.NOTEQCondition;
import com.suncode.cuf.archive.verification.internal.mode.ActivityVerificationMode;
import com.suncode.cuf.archive.verification.internal.mode.ProcessVerificationMode;
import com.suncode.cuf.archive.verification.internal.mode.StageVerificationMode;
import com.suncode.cuf.archive.verification.model.VerificationCondition;
import com.suncode.cuf.archive.verification.model.VerificationDefinition;
import com.suncode.cuf.archive.verification.model.VerificationResult;
import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@ComponentsFormScript(value="scripts/dynamic-pwe/verify-documents-form.js")
@Validator
public class VerifyDocuments {
    @Autowired
    private DocumentVerifier verifier;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("verify-documents")).name("validator.verify-documents.name")).description("validator.verify-documents.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/VoTK")).icon((Icon)SilkIconPack.ACCEPT)).parameter().id("verificationMode").name("validator.verify-documents.verify-mode.name").description("validator.verify-documents.verify-mode.desc").type((Type)Types.STRING).defaultValue((Object)"activity").create()).parameter().id("documentClassName").name("validator.verify-documents.documentClassName.name").description("validator.verify-documents.documentClassName.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("documentCount").name("validator.verify-documents.documentCount.name").description("validator.verify-documents.documentCount.desc").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("conditionType").name("validator.verify-documents.conditionType.name").description("validator.verify-documents.conditionType.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("fileNameRegExp").name("validator.verify-documents.fileNameRegExp.name").description("validator.verify-documents.fileNameRegExp.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("conditionalOperator").name("validator.verify-documents.conditionOperator.name").description("validator.verify-documents.conditionOperator.desc").type((Type)Types.STRING).defaultValue((Object)"AND").create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void validate(@Param String verificationMode, @Param String[] documentClassName, @Param Long[] documentCount, @Param String[] conditionType, @Param String[] fileNameRegExp, @Param String conditionalOperator, @Param Boolean confirmation, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (conditionalOperator.equals("AND")) {
            String result = this.validateDocuments(verificationMode, documentClassName, documentCount, conditionType, fileNameRegExp, validationContext);
            if (!StringUtils.isEmpty((Object)result)) {
                stringBuilder.append(result);
            }
        } else if (conditionalOperator.equals("OR")) {
            for (int i = 0; i < documentClassName.length; ++i) {
                String validationResult = this.validateDocuments(verificationMode, new String[]{documentClassName[i]}, new Long[]{documentCount[i]}, new String[]{conditionType[i]}, new String[]{fileNameRegExp[i]}, validationContext);
                if (StringUtils.isEmpty((Object)validationResult)) {
                    stringBuilder = new StringBuilder();
                    break;
                }
                stringBuilder.append(validationResult);
                stringBuilder.append(" ");
            }
        } else {
            throw new IllegalArgumentException("Unknown conditional operator");
        }
        if (stringBuilder.length() > 0) {
            if (confirmation.booleanValue()) {
                stringBuilder.append(" ");
                stringBuilder.append(translator.getMessage("validator.confirmation.question"));
                errors.addConfirmation(stringBuilder.toString(), translator.getMessage("validator.title_default"));
            } else {
                errors.add(stringBuilder.toString());
            }
        }
    }

    private String validateDocuments(String verificationMode, String[] documentClassName, Long[] documentCount, String[] conditionType, String[] fileNameRegExp, ValidationContext validationContext) {
        VerificationDefinition verificationDefinition = new VerificationDefinition();
        verificationDefinition.setProcessId(validationContext.getProcessId());
        verificationDefinition.setActivityId(validationContext.getActivityId());
        verificationDefinition.setMode(this.establishMode(verificationMode));
        List<VerificationCondition> verificationConditions = this.formVerificationConditions(documentClassName, documentCount, conditionType, fileNameRegExp);
        verificationDefinition.setConditions(verificationConditions);
        VerificationResult result = this.verifier.verifyDocuments(verificationDefinition);
        return result.getMessage();
    }

    private List<VerificationCondition> formVerificationConditions(String[] documentClassName, Long[] documentCount, String[] conditionType, String[] fileNameRegExp) {
        ArrayList<VerificationCondition> verificationConditions = new ArrayList<VerificationCondition>();
        for (int i = 0; i < documentClassName.length; ++i) {
            VerificationCondition verificationCondition = new VerificationCondition();
            if (!StringUtils.isEmpty((Object)documentClassName[i])) {
                verificationCondition.setDocumentClassName(documentClassName[i]);
            }
            if (documentCount != null) {
                verificationCondition.setDocumentCount(Integer.valueOf(documentCount[i].intValue()));
                verificationCondition.setConditionType(this.determineConditionType(conditionType[i]));
            }
            if (!StringUtils.isEmpty((Object)fileNameRegExp[i])) {
                verificationCondition.setFileNameRegExp(fileNameRegExp[i]);
            }
            verificationConditions.add(verificationCondition);
        }
        return verificationConditions;
    }

    private VerificationMode establishMode(String verificationMode) {
        ProcessVerificationMode mode;
        if (verificationMode.equalsIgnoreCase("process")) {
            mode = new ProcessVerificationMode();
        } else if (verificationMode.equalsIgnoreCase("activity")) {
            mode = new ActivityVerificationMode();
        } else if (verificationMode.equalsIgnoreCase("stage")) {
            mode = new StageVerificationMode();
        } else {
            throw new IllegalArgumentException("B\u0142\u0119dny tryb weryfikacji! Dozwolone tryby, to: process, activity i stage.");
        }
        return mode;
    }

    private ConditionType determineConditionType(String conditionType) {
        if (conditionType.equals("=")) {
            return new EQCondition();
        }
        if (conditionType.equals("!=")) {
            return new NOTEQCondition();
        }
        if (conditionType.equals("<")) {
            return new LTCondition();
        }
        if (conditionType.equals("<=")) {
            return new LECondition();
        }
        if (conditionType.equals(">")) {
            return new GTCondition();
        }
        if (conditionType.equals(">=")) {
            return new GECondition();
        }
        throw new IllegalArgumentException("B\u0142\u0119dny operator por\u00f3wnania! Dozwolone operatory, to: =, !=, <, <=, >, >=.");
    }
}

