/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.libreoffice.applications;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeConversionException;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeInitializationException;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeInvalidLicenceException;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeNotFoundException;
import com.suncode.cuf.common.documents.libreoffice.services.LibreOfficeService;
import com.suncode.cuf.common.utils.AutoCloseableTempFile;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileCipherService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="/scripts/dynamic-pwe/convert-document-to-pdf.js")
public class ConvertDocumentToPdf {
    private static final Logger log = LoggerFactory.getLogger(ConvertDocumentToPdf.class);
    private final List<Long> addedFiles = new ArrayList<Long>();
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private FileCipherService fileCipherService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FileService fileService;
    @Autowired
    private LibreOfficeService libreOfficeService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf")).name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.name")).description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.desc")).category(new Category[]{Categories.DOCUMENTS})).icon((Icon)SilkIconPack.PAGE_WHITE_ACROBAT)).parameter().id("sourceClassName").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.sourceClassName.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.sourceClassName.desc").type((Type)Types.STRING).create()).parameter().id("destinationClassName").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.destinationClassName.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.destinationClassName.desc").type((Type)Types.STRING).create()).parameter().id("newVersion").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.newVersion.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.newVersion.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create();
    }

    public void execute(@Param String sourceClassName, @Param Boolean newVersion, @Param String destinationClassName, ApplicationContext appContext, UserInfo userInfo) throws AcceptanceException, IOException {
        String processId = appContext.getProcessId();
        List docsFromProcess = this.documentFinder.getDocumentsFromProcessAndClass(processId, sourceClassName, new String[0]).stream().filter(wfDocument -> this.libreOfficeService.checkFileType(wfDocument.getFile().getFullPath())).collect(Collectors.toList());
        String outputPath = "";
        String username = "admin";
        if (userInfo != null) {
            username = userInfo.getUserName();
        }
        if (docsFromProcess.isEmpty()) {
            return;
        }
        try {
            this.libreOfficeService.open();
            Long destinationClassId = this.documentClassService.getDocumentClass(Boolean.TRUE.equals(newVersion) ? sourceClassName : destinationClassName, new String[0]).getId();
            for (WfDocument document : docsFromProcess) {
                outputPath = this.getPdfPath();
                WfFile wfFile = document.getFile();
                this.convertFile(wfFile, outputPath);
                if (!this.libreOfficeService.isSuccess()) {
                    log.error("Error converting file: " + wfFile.getFileName());
                    log.error("Rolling back changes...");
                    throw new LibreOfficeConversionException("Error converting file: " + wfFile.getFileName());
                }
                this.addDocument(Paths.get(outputPath, new String[0]).toFile(), document, username, processId, destinationClassId, newVersion);
                Files.deleteIfExists(Paths.get(outputPath, new String[0]));
            }
        }
        catch (LibreOfficeInitializationException | LibreOfficeInvalidLicenceException | LibreOfficeNotFoundException e) {
            throw new AcceptanceException("LibreOffice exception: " + e.getMessage());
        }
        catch (LibreOfficeConversionException e) {
            this.rollback();
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!StringUtils.isBlank((CharSequence)outputPath)) {
                Files.deleteIfExists(Paths.get(outputPath, new String[0]));
            }
            this.libreOfficeService.close();
        }
    }

    private void convertFile(WfFile inputFile, String outputPath) throws LibreOfficeConversionException {
        if (inputFile.isEncrypted()) {
            try (AutoCloseableTempFile tempFile = new AutoCloseableTempFile();){
                this.decryptFile(inputFile, tempFile);
                this.libreOfficeService.convertDocxToPdf(tempFile.getFile().getAbsolutePath(), outputPath);
            }
        } else {
            this.libreOfficeService.convertDocxToPdf(inputFile.getFullPath(), outputPath);
        }
    }

    private void decryptFile(WfFile inputFile, TempFile tempFile) throws LibreOfficeConversionException {
        try (FileInputStream inputStream = new FileInputStream(inputFile.getFullPath());
             InputStream decryptedInputStream = this.fileCipherService.decryptFile((InputStream)inputStream, inputFile.getCipherAlgorithm(), inputFile.getCipherKey());){
            FileUtils.copyInputStreamToFile((InputStream)decryptedInputStream, (File)tempFile.getFile());
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            log.error("Error decrypting file: " + inputFile.getFileName());
            log.error("Rolling back changes...");
            throw new LibreOfficeConversionException("Error decrypting file: " + inputFile.getFileName());
        }
    }

    private void rollback() {
        this.addedFiles.forEach(fileId -> {
            this.fileService.deleteFile(fileId);
            this.documentClassActionService.executeArchiveActions(this.documentService.getDocument(fileId), DocumentEventTypes.DELETE_DOCUMENT_FROM_ARCHIVE);
        });
        this.addedFiles.clear();
    }

    private void addDocument(File newFile, WfDocument sourceDocument, String username, String processId, Long newClassId, Boolean newVersion) throws LibreOfficeConversionException {
        try (FileInputStream is = new FileInputStream(newFile);){
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(newClassId);
            definition.setFileName(this.newFileName(sourceDocument.getFile().getFileName()));
            definition.setDescription(sourceDocument.getFile().getDescription());
            definition.setUserName(username);
            definition.setInputStream((InputStream)is);
            definition.setProcessId(processId);
            if (Boolean.TRUE.equals(newVersion)) {
                this.addedFiles.add(this.fileService.checkIn(definition, Long.valueOf(sourceDocument.getFile().getId()), ""));
            } else {
                this.addedFiles.add(this.documentService.addDocument(definition).getId());
            }
        }
        catch (Exception e) {
            throw new LibreOfficeConversionException(e.getMessage());
        }
    }

    private String newFileName(String filename) {
        CharSequence[] words = filename.split("\\.");
        if (words.length > 1) {
            words[words.length - 1] = "pdf";
        }
        return String.join((CharSequence)".", words);
    }

    private String getPdfPath() {
        String workingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        String millis = Long.toString(DateTime.now().getMillis());
        return Paths.get(workingDirectory, "temp_" + millis + ".pdf").toString();
    }
}

