/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents;

import com.suncode.cuf.common.documents.DocumentClassIndexDto;
import com.suncode.pwfl.archive.DocumentClass;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DocumentClassDto {
    private String name;
    private Long id;
    private String displayName;
    private List<DocumentClassIndexDto> indexes;

    public static DocumentClassDto fromEntity(DocumentClass docClass) {
        DocumentClassDto docClassDto = DocumentClassDto.builder().id(docClass.getId()).name(docClass.getName()).displayName(docClass.getName()).build();
        ArrayList<DocumentClassIndexDto> indexesDto = new ArrayList<DocumentClassIndexDto>();
        Set indexes = docClass.getIndexes();
        indexes.forEach(index -> {
            DocumentClassIndexDto indexDto = DocumentClassIndexDto.builder().id(index.getId()).name(index.getName()).type(index.getType().toString()).build();
            indexesDto.add(indexDto);
        });
        docClassDto.setIndexes(indexesDto);
        return docClassDto;
    }

    @ConstructorProperties(value={"name", "id", "displayName", "indexes"})
    DocumentClassDto(String name, Long id, String displayName, List<DocumentClassIndexDto> indexes) {
        this.name = name;
        this.id = id;
        this.displayName = displayName;
        this.indexes = indexes;
    }

    public static DocumentClassDtoBuilder builder() {
        return new DocumentClassDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<DocumentClassIndexDto> getIndexes() {
        return this.indexes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setIndexes(List<DocumentClassIndexDto> indexes) {
        this.indexes = indexes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentClassDto)) {
            return false;
        }
        DocumentClassDto other = (DocumentClassDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<DocumentClassIndexDto> this$indexes = this.getIndexes();
        List<DocumentClassIndexDto> other$indexes = other.getIndexes();
        return !(this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentClassDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<DocumentClassIndexDto> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentClassDto(name=" + this.getName() + ", id=" + this.getId() + ", displayName=" + this.getDisplayName() + ", indexes=" + this.getIndexes() + ")";
    }

    public static class DocumentClassDtoBuilder {
        private String name;
        private Long id;
        private String displayName;
        private List<DocumentClassIndexDto> indexes;

        DocumentClassDtoBuilder() {
        }

        public DocumentClassDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DocumentClassDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DocumentClassDtoBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public DocumentClassDtoBuilder indexes(List<DocumentClassIndexDto> indexes) {
            this.indexes = indexes;
            return this;
        }

        public DocumentClassDto build() {
            return new DocumentClassDto(this.name, this.id, this.displayName, this.indexes);
        }

        public String toString() {
            return "DocumentClassDto.DocumentClassDtoBuilder(name=" + this.name + ", id=" + this.id + ", displayName=" + this.displayName + ", indexes=" + this.indexes + ")";
        }
    }
}

