/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.datachoosers;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.PredefinedQueryUtils;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class DefinedQueryDataChooser {
    private static final Logger log = LoggerFactory.getLogger(DefinedQueryDataChooser.class);
    @Autowired
    DBService dbService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("defined-query-datachooser")).name("db.datachooser.defined-query.name")).description("db.datachooser.defined-query.desc")).category(new Category[]{Categories.DATABASE})).documentationLink("confluence/x/y4Ht")).icon((Icon)SilkIconPack.DATABASE_GO)).parameter().id("dbName").name("db.datachooser.defined-query.db-conf.name").description("db.datachooser.defined-query.db-conf.desc").type((Type)Types.STRING).create()).parameter().id("tableName").name("db.datachooser.defined-query.table_param.name").description("db.datachooser.defined-query.table_param.desc").type((Type)Types.STRING).defaultValue((Object)"pm_dbqueries").optional().create()).parameter().id("queryKey").name("db.datachooser.defined-query.query_key.name").description("db.datachooser.defined-query.query_key.desc").type((Type)Types.STRING).create()).parameter().id("queryParams").name("db.datachooser.defined-query.query_params.name").description("db.datachooser.defined-query.query_params.desc").type((Type)Types.STRING_ARRAY).optional().create()).enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult resultData, @Param String dbName, @Param String tableName, @Param String queryKey, @Param String[] queryParams, ActivityContextMap activityContext) {
        try {
            this.execute(dbName, tableName, queryKey, queryParams, resultData, queryData, activityContext);
        }
        catch (Exception e) {
            log.error("Could not execute DefinedQueryDataChooser.", (Throwable)e);
        }
    }

    private void execute(String dbName, String tableName, String queryKey, String[] queryParams, DataChooserResult resultData, ComponentQueryData queryData, ActivityContextMap activityContext) {
        for (int index = 0; index < queryParams.length; ++index) {
            if (!this.isFilterDCKEY(queryParams[index])) continue;
            queryParams[index] = this.getFilterValue(queryParams[index], queryData, activityContext);
        }
        this.getData(dbName, tableName, queryKey, resultData, queryParams, queryData, activityContext);
    }

    private String getFilterValue(String queryParam, ComponentQueryData queryData, ActivityContextMap activityContext) {
        if (queryParam.equals("DCKEY")) {
            return "'" + queryData.getQuery() + "'";
        }
        String idMapping = queryParam.substring(6);
        String value = (String)queryData.getFilters().get(idMapping);
        return value == null ? "" : value;
    }

    private boolean isFilterDCKEY(String string) {
        Pattern pDCKEY = Pattern.compile("^DCKEY");
        Matcher mDCKEY = pDCKEY.matcher(string);
        return mDCKEY.find();
    }

    private void getData(String dbName, String tableName, String queryKey, DataChooserResult result, String[] queryParams, ComponentQueryData queryData, ActivityContextMap activityContext) {
        Pagination pagination = queryData.getPagination();
        DBQueryConfig dbQueryCfg = DBQueryConfig.builder().dbName(dbName).queryTable(tableName).queryKey(queryKey).build();
        String query = this.dbService.getQuery(dbQueryCfg);
        if (!this.checkIsOrderBy(query)) {
            query = this.concatOrderBy(pagination, query);
        }
        dbQueryCfg.setQuery(query);
        dbQueryCfg.setFirst(pagination.getStart());
        dbQueryCfg.setMax(pagination.getLimit() + 1);
        dbQueryCfg.setQueryParams(PredefinedQueryUtils.getParamsValuesFromActivityContext(activityContext, queryParams));
        List<Map<String, String>> results = DataConverter.convertLMSOToLMSS(this.dbService.getDataFromQuery(dbQueryCfg));
        query = this.getValidCountQuery(query, dbName);
        dbQueryCfg.setQuery(query);
        Long totalSize = this.dbService.getCount(dbQueryCfg);
        this.formRowsAndSetTotal(results, totalSize, pagination, result);
    }

    private String getValidCountQuery(String query, String dbName) {
        return this.dbService.isDbType(dbName, DatabaseType.SQLSERVER) ? this.fixQueryForMSSQL(query) : query;
    }

    protected String fixQueryForMSSQL(String query) {
        if (query.trim().replaceAll(" +", " ").toLowerCase().contains("order by")) {
            query = query.replaceAll("[S|s][E|e][L|l][E|e][C|c][T|t] ( )*[D|d][I|i][S|s][T|t][I|i][N|n][C|c][T|t](?!( )*[T|t][O|o][P|p] ) ", "SELECT DISTINCT TOP 2147483647 ");
            return query.replaceAll("[S|s][E|e][L|l][E|e][C|c][T|t] (?!(( )*([D|d][I|i][S|s][T|t][I|i][N|n][C|c][T|t]|([T|t][O|o][P|p])) ))", "SELECT TOP 2147483647 ");
        }
        return query;
    }

    private boolean checkIsOrderBy(String query) {
        Pattern pDCKEY = Pattern.compile("order\\s+by");
        Matcher mDCKEY = pDCKEY.matcher(query.toLowerCase());
        return mDCKEY.find();
    }

    private String concatOrderBy(Pagination pagination, String query) {
        return query.concat(" ORDER BY " + pagination.getSorter().getProperty() + " " + pagination.getSorter().getDirection().name());
    }

    private void formRowsAndSetTotal(List<Map<String, String>> results, Long totalSize, Pagination pagination, DataChooserResult result) {
        if (results.size() > pagination.getLimit()) {
            results = results.subList(0, pagination.getLimit());
        }
        for (Map<String, String> row : results) {
            DataChooserResult.Row resultRow = result.row();
            for (String key : row.keySet()) {
                String value = row.get(key);
                resultRow.value(key, value);
            }
        }
        result.setTotal(totalSize.longValue());
    }
}

