/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db;

import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.filters.BetweenQueryFilter;
import com.suncode.cuf.common.db.filters.QueryFilter;
import com.suncode.cuf.common.db.sorters.QuerySorter;
import com.suncode.cuf.common.db.tables.DBQuery;
import com.suncode.cuf.common.db.tables.DBQueryService;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.query.Conditions;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="queryBuilder")
public class QueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryBuilder.class);
    private DBQueryService dbQueryService;
    private SQLFinder sqlFinder;

    @Autowired
    public QueryBuilder(DBQueryService dbQueryService, SQLFinder sqlFinder) {
        this.dbQueryService = dbQueryService;
        this.sqlFinder = sqlFinder;
    }

    public String createMultiQuery(DatabaseSession session, List<DBQueryConfig> queries) {
        String query = this.getQueryFromDB(session, queries.get(0));
        return this.createMultiQuery(session, query, queries.size());
    }

    public String getQueryFromDB(DatabaseSession session, DBQueryConfig dbQueryCfg) {
        String query = "";
        if (dbQueryCfg.getQuery() != null) {
            query = dbQueryCfg.getQuery();
        }
        String queryKey = dbQueryCfg.getQueryKey();
        String table = dbQueryCfg.getQueryTable();
        if (StringUtils.hasText((String)table) && !StringUtils.hasText((String)query)) {
            try {
                List<Map<String, Object>> records = this.getRecordsFromMainDB(table, queryKey);
                if (records != null && records.size() > 0) {
                    query = (String)records.get(0).get("query");
                }
            }
            catch (Exception e) {
                log.debug("Error while getting data from table: " + table + " in system DB.");
                log.debug(e.getMessage());
            }
            if (!StringUtils.hasText((String)query)) {
                Record record = session.select().from(table).where(Conditions.eq((String)"query_name", (Object)queryKey)).uniqueRecord();
                if (record == null) {
                    throw new IllegalArgumentException("No query with query_name '" + queryKey + "' found in table '" + table + "'");
                }
                query = (String)record.getData().get("query");
            }
        }
        if (!StringUtils.hasText((String)query)) {
            query = this.getQueryFromDBQueries(queryKey);
        }
        Assert.notNull((Object)query, (String)"Could not find query under specified key.");
        if (dbQueryCfg.isChangeQuestionMarksToNamedParameters()) {
            query = this.swapQuestionMarks(query);
        }
        if (!dbQueryCfg.getFilters().isEmpty()) {
            query = this.addFiltersToQuery(query, dbQueryCfg.getFilters());
        }
        if (!dbQueryCfg.getSorters().isEmpty()) {
            query = this.addSortersToQuery(query, dbQueryCfg.getSorters());
        }
        return query;
    }

    public List<Map<String, Object>> getRecordsFromMainDB(String table, String queryKey) {
        if (!this.isTableInMainDB(table)) {
            log.debug("Table '" + table + "' hasn't been found in system DB. ");
            return null;
        }
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select query from " + table + " where query_name=:key");
        builder.setParameter("key", (Object)queryKey);
        builder.addScalar("query", (Type)StandardBasicTypes.STRING);
        return this.sqlFinder.find(builder);
    }

    public String getCountQueryFromDB(DatabaseSession session, DBQueryConfig dbQueryCfg) throws SQLException {
        String databaseName = session.getConnection().getMetaData().getDatabaseProductName();
        String query = databaseName.equals("Microsoft SQL Server") ? this.fixQueryForMSSQL(this.getQueryFromDB(session, dbQueryCfg)) : this.getQueryFromDB(session, dbQueryCfg);
        return "select count(*) as cnt from (" + query + ") data ";
    }

    private String getQueryFromDBQueries(String queryName) throws NoResultException {
        DBQuery dbQuery = this.dbQueryService.getQueryByName(queryName);
        if (dbQuery == null) {
            throw new NoResultException("Nie znaleziono zapytania o podanym queryName");
        }
        return dbQuery.getQuery();
    }

    private String swapQuestionMarks(String query) {
        int questionMarkCount = StringUtils.countOccurrencesOf((String)query, (String)"?");
        for (int i = 0; i < questionMarkCount; ++i) {
            query = query.replaceFirst("\\?", ":param" + i);
        }
        return query;
    }

    private String addFiltersToQuery(String query, List<QueryFilter> filters) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ( ");
        sb.append(query);
        sb.append(" ) filteredData WHERE ");
        this.resolveDateFormat(filters);
        for (int i = 0; i < filters.size(); ++i) {
            sb.append(filters.get(i).getFilter());
            if (i == filters.size() - 1) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    private String addSortersToQuery(String query, List<QuerySorter> sorters) {
        StringBuilder builder = new StringBuilder();
        builder.append(query);
        builder.append(" ORDER BY ");
        for (int i = 0; i < sorters.size(); ++i) {
            builder.append(sorters.get(i).getSorter());
            if (i == sorters.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private boolean isTableInMainDB(String table) {
        SQLBuilder builder = new SQLBuilder();
        String tableExistQuery = NativeDatabase.getImplementation().getTableExistsQuery(table);
        builder.setQuery(tableExistQuery);
        List records = this.sqlFinder.find(builder);
        return records.size() == 1;
    }

    protected String fixQueryForMSSQL(String query) {
        if (query.trim().replaceAll(" +", " ").toLowerCase().contains("order by")) {
            query = query.replaceAll("[S|s][E|e][L|l][E|e][C|c][T|t] ( )*[D|d][I|i][S|s][T|t][I|i][N|n][C|c][T|t](?!( )*[T|t][O|o][P|p] ) ", "SELECT DISTINCT TOP 2147483647 ");
            return query.replaceAll("[S|s][E|e][L|l][E|e][C|c][T|t] (?!(( )*([D|d][I|i][S|s][T|t][I|i][N|n][C|c][T|t]|([T|t][O|o][P|p])) ))", "SELECT TOP 2147483647 ");
        }
        return query;
    }

    protected String createMultiQuery(DatabaseSession session, String query, int size) {
        query = query.endsWith(";") ? query.substring(0, query.length() - 1) : query;
        boolean isOracleDatabase = this.isOracleDatabase(session);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT DISTINCT ");
            builder.append(i);
            builder.append(" as RESULT FROM (");
            builder.append(query);
            builder.append(")");
            if (!isOracleDatabase) {
                builder.append(" as T");
                builder.append(i);
            }
            if (i == size - 1) continue;
            builder.append(" UNION ");
        }
        return builder.toString();
    }

    private void resolveDateFormat(List<QueryFilter> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            if (!(filters.get(i) instanceof BetweenQueryFilter)) continue;
            try {
                String firstDate = this.retrieveStringFormatFromDate(filters.get(i).getValue());
                String secondDate = this.retrieveStringFormatFromDate(((BetweenQueryFilter)filters.get(i)).getSecondValue());
                String property = filters.get(i).getProperty();
                filters.set(i, new BetweenQueryFilter(property, firstDate, secondDate));
                continue;
            }
            catch (DateTimeParseException e) {
                return;
            }
        }
    }

    private String retrieveStringFormatFromDate(Object date) {
        return ZonedDateTime.parse(date.toString(), DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz uuuu").withLocale(Locale.US)).toLocalDate().toString();
    }

    private boolean isOracleDatabase(DatabaseSession session) {
        try {
            return session.getConnection().getMetaData().getDatabaseProductName().equals("Oracle");
        }
        catch (Exception e) {
            log.error("Could not retrieve database type.");
            return false;
        }
    }
}

