/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.activity.servlets;

import com.google.common.base.Joiner;
import com.suncode.cuf.common.activity.servlets.dto.AcceptActivityRequestParamsDto;
import com.suncode.cuf.common.activity.servlets.dto.AcceptActivityResultDto;
import com.suncode.cuf.common.activity.servlets.dto.ActivityStateDto;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.CheckActivityAccess;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.form.validator.error.ValidationError;
import com.suncode.pwfl.workflow.form.validator.error.ValidationException;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ActivityController"})
public class ActivityController {
    private static final Logger log = LoggerFactory.getLogger(ActivityController.class);
    @Autowired
    private ActivityService activityService;
    @Autowired
    private VariableFactory variableFactory;
    private static Translator translator;
    private static final CheckActivityAccess checkActivityAccess;

    @RequestMapping(value={"acceptActivity"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public CountedResult<AcceptActivityResultDto> acceptActivity(HttpServletRequest request, @RequestBody AcceptActivityRequestParamsDto params) {
        String userLogin = request.getSession().getAttribute("username").toString();
        if (!checkActivityAccess.canUserViewActivityHistory(userLogin, params.getProcessId(), params.getActivityId(), request.getParameter("key"))) {
            log.error(String.format("User %s does not have permissions for the task %s.", userLogin, params.getActivityId()));
            throw new ActivityControllerException(this.translate("cuf.common.activity.servlets.acceptActivity.NO_PERMISSION"));
        }
        if (!this.activityService.getActivity(params.getProcessId(), params.getActivityId(), new String[0]).isOpen()) {
            log.error(String.format("Activity %s is not open.", params.getActivityId()));
            throw new ActivityControllerException(this.translate("cuf.common.activity.servlets.acceptActivity.NO_OPEN_ACTIVITY"));
        }
        Map<String, Object> contextMap = this.createContextMap(params.getProcessId(), params.getActivityId(), params.getVariableValueMap());
        CountedResult response = new CountedResult();
        try {
            AcceptationDefinition acceptationDefinition = new AcceptationDefinition(params.getProcessId(), params.getActivityId(), userLogin, params.getAcceptButtonId(), contextMap, true);
            acceptationDefinition.setIgnoreValidators(params.getIgnoreValidatorsUnderButton());
            this.activityService.acceptActivity(acceptationDefinition);
            List openActivitiesForProcess = this.activityService.getOpenActivitiesForProcess(params.getProcessId());
            response.setTotal((long)openActivitiesForProcess.size());
            List activityData = openActivitiesForProcess.stream().map(activity -> new AcceptActivityResultDto(activity.getActivityId(), this.activityService.getAssignments(params.getProcessId(), activity.getActivityId()))).collect(Collectors.toList());
            response.setData(activityData);
        }
        catch (ValidationException validationException) {
            throw new ActivityControllerException(this.getValidationExceptionMessages(validationException));
        }
        catch (Exception e) {
            ValidationException validationException = this.findCause(e, ValidationException.class);
            if (validationException != null) {
                throw new ActivityControllerException(this.getValidationExceptionMessages(validationException));
            }
            throw new ActivityControllerException(e.getMessage());
        }
        return response;
    }

    private ValidationException findCause(Throwable e, Class<ValidationException> target) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (!target.isInstance(t)) continue;
            return (ValidationException)t;
        }
        return null;
    }

    private String getValidationExceptionMessages(ValidationException validationException) {
        return validationException.getErrors().getErrors().stream().map(ValidationError::getMessage).collect(Collectors.joining("\n"));
    }

    private Map<String, Object> createContextMap(String processId, String activityId, Map<String, Object> variableValueMap) {
        Map activityContext = this.activityService.getActivityContext(processId, activityId);
        Map variables = this.variableFactory.createVariables(processId, activityId, activityContext, true);
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (!variableValueMap.isEmpty()) {
            variableValueMap.forEach((key, value) -> {
                Variable variable = (Variable)variables.get(key);
                String stringValue = value instanceof List ? Joiner.on((String)";").join((Iterable)value) : (String)value;
                variable.setValue(DataConverter.stringToObject(stringValue, variable.getType()));
                contextMap.put((String)key, variable.getValueAsBasicType());
            });
        }
        return contextMap;
    }

    @ExceptionHandler(value={ActivityControllerException.class})
    public ResponseEntity<String> handleItemNotFoundException(ActivityControllerException ex) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(new MediaType("text", "plain", StandardCharsets.UTF_8));
        return new ResponseEntity((Object)ex.getMessage(), (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
    }

    private String translate(String key) {
        if (null == translator) {
            translator = Translators.get(ActivityController.class);
        }
        LocalizedString text = new LocalizedString(key, translator, new Object[0]);
        return text.getOptional();
    }

    @ResponseBody
    @RequestMapping(value={"/activityState"}, method={RequestMethod.GET})
    public String getActivityState(@RequestParam String processId, @RequestParam String activityId) {
        Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
        return activity.getState().getStateText();
    }

    @ResponseBody
    @RequestMapping(value={"/activityStateList"}, method={RequestMethod.GET})
    public CountedResult<ActivityStateDto> getActivityStates(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List<ActivityStateDto> activityStateDtoList = ActivityController.getAllActivityStateDto();
        return new CountedResult((long)activityStateDtoList.size(), activityStateDtoList);
    }

    public static List<ActivityStateDto> getAllActivityStateDto() {
        return Arrays.stream(ActivityState.values()).filter(state -> !"PROCESSING".equals(state.name())).map(state -> new ActivityStateDto(state.name(), state.getStateText(), state.getStateNumber())).collect(Collectors.toList());
    }

    static {
        checkActivityAccess = (CheckActivityAccess)SpringContext.getBean(CheckActivityAccess.class);
    }

    public static class ActivityControllerException
    extends RuntimeException {
        public ActivityControllerException(String message) {
            super(message);
        }
    }
}

